#!/bin/sh

PACKAGE_DIR=/usr/src/gnome/packages
FILELIST=/usr/src/gnome/scripts/DroplineFiles2c

declare -a OldFileList

if [ ! -d "$PACKAGE_DIR" ]; then
	echo "Error: $PACKAGE_DIR does not exist"
	exit 1
fi
if [ ! -e "$FILELIST" ]; then
	echo "Error: $FILELIST does not exist"
	exit 1
fi

cd "$PACKAGE_DIR"
cp "$FILELIST" ./FileList
cat /dev/null > ./FileList.tmp

index=0
word="installed"
while [ -n "$word" ]
do
	read word
	if [[ "$word" != "" && "$word" != "installed" ]]; then
		OldFileList[$index]="$word"
		let "index += 1"
	fi
done < ./FileList

count=${#OldFileList[@]}

for file in *.tgz
do
	if [ "$file" == "*.tgz" ]; then
		continue;
	fi
	filename=`echo "$file" | cut -f 1 -d '.' | sed -e 's/-[0-9]//g'`
	echo "processing $filename..."
	index=0
	found=0
	while [ "$index" -le "$count" ]
	do
		oldfilename=`echo "${OldFileList[$index]}" | cut -f 1 -d '.' | sed -e 's/-[0-9]//g'`
		if [ "$oldfilename" == "$filename" ]; then
			field2=`echo "${OldFileList[$index]}" | cut -f 2 -d ':'`
			field3=`echo "${OldFileList[$index]}" | cut -f 3 -d ':'`
			field4=`echo "${OldFileList[$index]}" | cut -f 4 -d ':'`
			md5=`md5sum $file | cut -f 1 -d ' '`
			size_spaced=`ls -l $file`
			size=`echo $size_spaced | cut -f 5 -d ' '`
			field7=`echo "${OldFileList[$index]}" | cut -f 7 -d ':'`
			field8=`echo "${OldFileList[$index]}" | cut -f 8 -d ':'`
			newfile=$(printf "%s:%s:%s:%s:%s:%s:%s:%s" $file "$field2" "$field3" "$field4" "$md5" "$size" "$field7" "$field8" )
			oldfile="${OldFileList[$index]}"
			sed -e "s@$oldfile@$newfile@" FileList > FileList.tmp
			cp FileList.tmp FileList
			found=1
		fi
		let "index += 1"
	done
	if [ "$found" == "0" ]; then
		md5=`md5sum $file | cut -f 1 -d ' '`
		size_spaced=`ls -l $file`
		size=`echo $size_spaced | cut -f 5 -d ' '`
		newfile=$(printf "%s::::%s:%s::" "$file" "$md5" "$size")
		echo "$newfile" >> FileList
	fi
done

mv FileList "$FILELIST"

echo "Done!"
