%define _unpackaged_files_terminate_build 0
%define toolkit_options --disable-freetype2
%define builddir %{_builddir}/mozilla

Name:        mozilla
Summary:     Web browser and mail reader
Version:     1.2.1
Release:     1
Serial:      35
Copyright:   MPL
Source0:     mozilla-source.tar.bz2
Source1:     mozilla.sh.in
Source2:     mozilla-icon.png
Source4:     mozilla.desktop
Source7:     mozilla-make-package.pl
Source9:     mozicon16.xpm
Source10:    mozicon50.xpm
Source11:    mozilla-rebuild-databases.pl.in
Source12:    mozilla-mail.desktop
Source13:    mozilla-mail-icon.gif
Source14:    mozilla-compose.desktop
Source15:    mozilla-compose-icon.gif
Source16:    mozilla-exclude-list
Source17:    mozilla-psm-exclude-list
Source18:    mozilla-xpcom-exclude-list
Source19:    mozilla-redhat-default-bookmarks.html
Patch0:      mozilla-navigator-overlay-menu.patch
Patch1:      mozilla-editor-overlay-menu.patch
Patch6:      mozilla-prefs-debug.patch
Patch7:      mozilla-redhat-home-page.patch
Patch8:      mozilla-redhat-mail-home-page.patch
Patch11:     mozilla-taskbar-nomozilla.patch
Patch12:     mozilla-psfonts-7.2.patch
Patch13:     mozilla-nspr-packages.patch
Patch14:     mozilla-default-plugin-less-annoying.patch
Patch17:     mozilla-buildid-title.patch
Patch18:     mozilla-gtk2.patch
Patch19:     mozilla-dropline-homepage.patch
Buildroot:   /var/tmp/mozilla-root
Prefix:      /usr
Group:       Applications/Internet
Provides:    webclient

%description
Mozilla is an open-source web browser, designed for standards
compliance, performance and portability.

%package nspr
Summary: Netscape Portable Runtime
Group: Applications/Internet
Conflicts: mozilla < 0.9.9

%description nspr
NSPR provides platform independence for non-GUI operating system
facilities. These facilities include threads, thread synchronization,
normal file and network I/O, interval timing and calendar time, basic
memory management (malloc and free) and shared library linking.

%package nspr-devel
Summary: Development Libraries for the Netscape Portable Runtime
Group: Development/Libraries

%description nspr-devel
Header files for doing development with the Netscape Portable Runtime.

%package nss
Summary: Network Security Services
Group: Applications/Internet

%description nss
Network Security Services (NSS) is a set of libraries designed to
support cross-platform development of security-enabled server
applications. Applications built with NSS can support SSL v2 and v3,
TLS, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME, X.509 v3
certificates, and other security standards.

%package nss-devel
Summary: Development Libraries for Network Security Services
Group: Applications/Internet

%description nss-devel
Header files to doing development with Network Security Services.

%package devel
Summary: Development files for Mozilla
Group: Development/Libraries

%description devel
Development header files for mozilla.

%package mail
Summary: Mozilla-based mail system
Group: Applications/Internet

%description mail
Mail/news client based on the Mozilla web browser.  The mail/news
client supports IMAP, POP, and NNTP and has an easy to use interface.

%package psm
Summary: Personal Security Manager
Group: Applications/Internet

%description psm
The Personal Security Manager is a set of libraries that allow Mozilla
to talk to the Network Security Services layer.  It allows Mozilla to
access SSL web sites and manage cryptographic keys.

%package chat
Summary: IRC client integrated with Mozilla
Group: Applications/Internet

%description chat
IRC client that is integrated with the Mozilla web browser.

%package js-debugger
Summary: JavaScript debugger for use with Mozilla
Group: Applications/Internet

%description js-debugger
JavaScript debugger for use with Mozilla.

%package dom-inspector
Summary: A tool for inspecting the DOM of pages in Mozilla.
Group: Applications/Internet

%description dom-inspector
This is a tool that allows you to inspect the DOM for web pages in
Mozilla.  This is of great use to people who are doing Mozilla chrome
development or web page development.

%prep

%setup -q -n mozilla

#%patch0 -p1
#%patch0 -p1 -R

#%patch1 -p1
#%patch1 -p1 -R

#%patch6 -p1
#%patch6 -p1 -R

#%patch7 -p1
#%patch7 -p1 -R

#%patch8 -p1
#%patch8 -p1 -R

#%patch11 -p1
#%patch11 -p1 -R

# Can't hurt to leave this in since the defaults are empty.
%patch12 -p1

%patch13 -p1

# make the plugin dialog less annoying and disable redirection to the
# plugin downloader page.
%patch14 -p1

# remove the annoying buildid from the titlebar
#%patch17 -p1
#%patch17 -p1 -R

#%patch18 -p1

%patch19 -p1

# set up our default bookmarks
#/bin/cp %{SOURCE19} $RPM_BUILD_DIR/mozilla/profile/defaults/bookmarks.html

%build

if [ -x /usr/bin/getconf ]; then
  CPUS=`getconf _NPROCESSORS_ONLN`
fi
if test "x$CPUS" = "x" -o "x$CPUS" = "x0"; then
  CPUS=1
fi

# build mozilla
BUILD_OFFICIAL=1 MOZILLA_OFFICIAL=1 \
	./configure --prefix=%{_prefix} --enable-optimize="-O3" \
	--disable-debug \
	--with-default-mozilla-five-home=/usr/lib/mozilla-%{version} \
	--enable-strip-libs \
	--disable-tests \
	--disable-short-wchar \
	--enable-nspr-autoconf \
	--enable-extensions=default,irc \
	--without-mng \
	--enable-crypto \
	--disable-xprint \
	--without-system-nspr \
	--with-system-zlib \
	--enable-xft \
	--enable-default-toolkit=gtk


BUILD_OFFICIAL=1 MOZILLA_OFFICIAL=1 make -s export
BUILD_OFFICIAL=1 MOZILLA_OFFICIAL=1 make -j$CPUS -s libs

%install
/bin/rm -rf $RPM_BUILD_ROOT

BUILD_OFFICIAL=1 MOZILLA_OFFICIAL=1 \
	DESTDIR=$RPM_BUILD_ROOT \
	make install

# create a list of all of the different package and the files that
# will hold them

/bin/rm -f %{builddir}/mozilla.list
/bin/rm -f %{builddir}/mozilla-mail.list
/bin/rm -f %{builddir}/mozilla-psm.list
/bin/rm -f %{builddir}/mozilla-chat.list
/bin/rm -f %{builddir}/mozilla-js-debugger.list
/bin/rm -f %{builddir}/mozilla-dom-inspector.list

# NSS and NSPR are both installed into /usr/lib instead of
# /usr/lib/mozilla-VERSION

pushd .
cd $RPM_BUILD_ROOT/usr/lib/mozilla-%{version}
# copy nspr
mv -v \
  libnspr4.so libplc4.so libplds4.so \
  $RPM_BUILD_ROOT/usr/lib/

# copy nss
mv -v \
  libnss3.so libsmime3.so libsoftokn3.so libssl3.so \
  $RPM_BUILD_ROOT/usr/lib/

# copy system libs
for i in libgkgfx.so libjsj.so libmozjs.so libxpcom.so \
  libgtkembedmoz.so libgtksuperwin.so libgtkxtbin.so
do
  if [ -f $i ]; then
    mv -v $i $RPM_BUILD_ROOT/usr/lib/
    echo /usr/lib/$i >> %{builddir}/mozilla.list
  else
    echo $i does not exist - skipping
  fi
done

# libnssckbi.so must be in both places
cp -v libnssckbi.so $RPM_BUILD_ROOT/usr/lib/
popd

/bin/rm -f %{builddir}/mozilla-nspr.list
%{SOURCE7} --package nspr --output-file %{builddir}/mozilla-nspr.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/usr/lib \
    --install-root /usr/lib

/bin/rm -f %{builddir}/mozilla-nss.list
%{SOURCE7} --package nss --output-file %{builddir}/mozilla-nss.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/usr/lib \
    --install-root /usr/lib

# manually add the libnssckbi.so file
echo /usr/lib/mozilla-%{version}/libnssckbi.so >> %{builddir}/mozilla-nss.list

# build all of the default browser components
# base mozilla package (mozilla.list)
%{SOURCE7} --package langenus --output-file %{builddir}/mozilla.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/usr/lib/mozilla-%{version} \
    --install-root /usr/lib/mozilla-%{version}

%{SOURCE7} --package regus --output-file %{builddir}/mozilla.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/usr/lib/mozilla-%{version} \
    --install-root /usr/lib/mozilla-%{version}

%{SOURCE7} --package deflenus --output-file %{builddir}/mozilla.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/usr/lib/mozilla-%{version} \
    --install-root /usr/lib/mozilla-%{version}

%{SOURCE7} --package xpcom --output-file %{builddir}/mozilla.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/usr/lib/mozilla-%{version} \
    --install-root /usr/lib/mozilla-%{version} \
    --exclude-file=%{SOURCE18}

%{SOURCE7} --package browser --output-file %{builddir}/mozilla.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/usr/lib/mozilla-%{version} \
    --install-root /usr/lib/mozilla-%{version} \
    --exclude-file=%{SOURCE16}

# mozilla mail (mozilla-mail.list)
%{SOURCE7} --package mail --output-file %{builddir}/mozilla-mail.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/usr/lib/mozilla-%{version} \
    --install-root /usr/lib/mozilla-%{version}

# mozilla psm (mozilla-psm.list)
%{SOURCE7} --package psm --output-file %{builddir}/mozilla-psm.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/usr/lib/mozilla-%{version} \
    --install-root /usr/lib/mozilla-%{version} \
    --exclude-file=%{SOURCE17}

# mozilla chat (mozilla-chat.list)
%{SOURCE7} --package chatzilla --output-file %{builddir}/mozilla-chat.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/usr/lib/mozilla-%{version} \
    --install-root /usr/lib/mozilla-%{version}

# mozilla JS debugger (mozilla-js-debugger.list)
%{SOURCE7} --package venkman --output-file %{builddir}/mozilla-js-debugger.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/usr/lib/mozilla-%{version} \
    --install-root /usr/lib/mozilla-%{version}

# mozilla DOM inspector (mozilla-dom-inspector.list)
%{SOURCE7} --package inspector --output-file %{builddir}/mozilla-dom-inspector.list \
    --package-file $RPM_BUILD_DIR/mozilla/xpinstall/packager/packages-unix \
    --install-dir $RPM_BUILD_ROOT/usr/lib/mozilla-%{version} \
    --install-root /usr/lib/mozilla-%{version}

# build our initial component and chrome registry
# we don't need to do this anymore

pushd `pwd`
  cd $RPM_BUILD_ROOT/%{prefix}/lib/mozilla-%{version}
  # register our components
  LD_LIBRARY_PATH=`pwd`:`pwd`/.. MOZILLA_FIVE_HOME=`pwd` ./regxpcom
  # set up the default skin and locale to trigger the generation of
  # the user-locales and users-skins.rdf
  echo "skin,install,select,classic/1.0" >> chrome/installed-chrome.txt
  echo "locale,install,select,en-US" >> chrome/installed-chrome.txt
  # set up the chrome rdf files
  LD_LIBRARY_PATH=`pwd`:`pwd`/.. MOZILLA_FIVE_HOME=`pwd` ./regchrome
  # fix permissions of the chrome directories
  /usr/bin/find . -type d -perm 0700 -exec chmod 755 {} \; || :
popd

# cp -L (dereference all symlinks) is required for fileutils >= 2.0.27
# (POSIX compliance); prior versions don't understand -L, so fall back...

# copy the nss files to the right place
mkdir $RPM_BUILD_ROOT/%{prefix}/include/mozilla-%{version}/nss/

/usr/bin/find security/nss/lib/ -name '*.h' -type f -exec /bin/cp {} \
 $RPM_BUILD_ROOT/%{prefix}/include/mozilla-%{version}/nss/ \;

# build the list of include files
rm -f %{builddir}/mozilla-devel.list
rm -f %{builddir}/mozilla-nss-devel.list
rm -f %{builddir}/mozilla-nspr-devel.list

find $RPM_BUILD_ROOT/%{prefix}/include/mozilla-%{version}/ -type f | \
  sed -e "s,$RPM_BUILD_ROOT,," | \
  grep -v "/%{prefix}/include/mozilla-%{version}/nss" | \
  grep -v "/%{prefix}/include/mozilla-%{version}/nspr" > \
  %{builddir}/mozilla-devel.list

find $RPM_BUILD_ROOT/%{prefix}/include/mozilla-%{version}/ -type f | \
  sed -e "s,$RPM_BUILD_ROOT,," | \
  grep "/%{prefix}/include/mozilla-%{version}/nspr" > \
  %{builddir}/mozilla-nspr-devel.list

find $RPM_BUILD_ROOT/%{prefix}/include/mozilla-%{version}/ -type f| \
  sed -e "s,$RPM_BUILD_ROOT,," | \
  grep "/%{prefix}/include/mozilla-%{version}/nss" > \
  %{builddir}/mozilla-nss-devel.list

# copy our idl into place
#mkdir -p $RPM_BUILD_ROOT/%{prefix}/share/idl/mozilla-%{version}
#(cd dist/idl ; tar chf - * | \
#  (cd $RPM_BUILD_ROOT/%{prefix}/share/idl/mozilla-%{version} ; \
#   tar xvf -))

# copy our devel tools
install -c -m 755 dist/bin/xpcshell \
  dist/bin/xpidl \
  dist/bin/xpt_dump \
  dist/bin/xpt_link \
  $RPM_BUILD_ROOT/%{prefix}/lib/mozilla-%{version}

# set up our desktop files
/bin/mkdir -p $RPM_BUILD_ROOT/%{prefix}/share/pixmaps/
/bin/mkdir -p $RPM_BUILD_ROOT/etc/X11/applnk/Internet

install -c -m 644 %{SOURCE2} %{SOURCE13} %{SOURCE15} \
  $RPM_BUILD_ROOT/%{prefix}/share/pixmaps/

install -c -m 644  %{SOURCE4} %{SOURCE12} %{SOURCE14} \
  $RPM_BUILD_ROOT/etc/X11/applnk/Internet

if [ ! -d $RPM_BUILD_ROOT/usr/lib/mozilla-%{version}/icons/ ]; then
  mkdir -m 755 $RPM_BUILD_ROOT/usr/lib/mozilla-%{version}/icons
fi

if [ ! -d $RPM_BUILD_ROOT/usr/lib/mozilla-%{version}/plugins/ ]; then
  mkdir -m 755 $RPM_BUILD_ROOT/usr/lib/mozilla-%{version}/plugins
fi

# our icons are better!
install -c -m 644 %{SOURCE9} $RPM_BUILD_ROOT/usr/lib/mozilla-%{version}/icons/
install -c -m 644 %{SOURCE10} $RPM_BUILD_ROOT/usr/lib/mozilla-%{version}/icons/

# install our mozilla.sh file
cat %{SOURCE1} | sed -e 's/MOZILLA_VERSION/%{version}/g' > \
  $RPM_BUILD_ROOT/usr/bin/mozilla

chmod 755 $RPM_BUILD_ROOT/usr/bin/mozilla

# install our rebuild file
cat %{SOURCE11} | sed -e 's/MOZILLA_VERSION/%{version}/g' > \
  $RPM_BUILD_ROOT/usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl

chmod 755 \
  $RPM_BUILD_ROOT/usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl

%clean
#/bin/rm -rf $RPM_BUILD_ROOT

%post
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%postun
/sbin/ldconfig >/dev/null 2>/dev/null
# was this an upgrade?
if [ "$1" == "2" ]; then
  if [ -f /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
      /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl
  fi
fi

%triggerpostun -- mozilla < 1.0
# Older packages will leave mozilla unusable after the postun script
# script is run for the old package.  Rebuild the databases after that
# has been run.
if [ -f /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%preun
# is a final removal?
if [ "$1" == "0" ]; then
  /bin/rm -rf /usr/lib/mozilla/chrome/overlayinfo
  /bin/rm -f /usr/lib/mozilla/chrome/*.rdf
fi

%post nspr
/sbin/ldconfig >/dev/null 2>/dev/null

%postun nspr
/sbin/ldconfig >/dev/null 2>/dev/null

%post nss
/sbin/ldconfig >/dev/null 2>/dev/null

%postun nss
/sbin/ldconfig >/dev/null 2>/dev/null

%post mail
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%postun mail

# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%post psm
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%postun psm
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%post chat
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%postun chat
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%post js-debugger
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%postun js-debugger
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%post dom-inspector
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%postun dom-inspector
# run ldconfig before regxpcom
/sbin/ldconfig >/dev/null 2>/dev/null

if [ -f /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl ]; then
    /usr/lib/mozilla-%{version}/mozilla-rebuild-databases.pl
fi

%files -f mozilla.list
%defattr(-,root,root)
%{prefix}/bin/mozilla
%{prefix}/lib/mozilla-%{version}/mozilla-rebuild-databases.pl
%{prefix}/share/pixmaps/mozilla-icon.png
%{prefix}/share/pixmaps/mozilla-mail-icon.gif
%{prefix}/share/pixmaps/mozilla-compose-icon.gif

%verify (not md5 mtime size) %{prefix}/lib/mozilla-%{version}/components/compreg.dat
%verify (not md5 mtime size) %{prefix}/lib/mozilla-%{version}/components/xpti.dat

%dir %{prefix}/lib/mozilla-%{version}/defaults/pref
%dir %{prefix}/lib/mozilla-%{version}/defaults/profile
%dir %{prefix}/lib/mozilla-%{version}/defaults/wallet
%dir %{prefix}/lib/mozilla-%{version}/defaults
%dir %{prefix}/lib/mozilla-%{version}/chrome
%dir %{prefix}/lib/mozilla-%{version}/components
%dir %{prefix}/lib/mozilla-%{version}/res/builtin
%dir %{prefix}/lib/mozilla-%{version}/res/rdf
%dir %{prefix}/lib/mozilla-%{version}/res
%dir %{prefix}/lib/mozilla-%{version}/icons
%dir %{prefix}/lib/mozilla-%{version}/defaults/profile/US
%dir %{prefix}/lib/mozilla-%{version}/searchplugins

%dir %{prefix}/lib/mozilla-%{version}/plugins
%dir %{prefix}/lib/mozilla-%{version}/res/html
%dir %{prefix}/lib/mozilla-%{version}/res/samples
%dir %{prefix}/lib/mozilla-%{version}/res/entityTables

/etc/X11/applnk/Internet/mozilla.desktop

%files nspr -f mozilla-nspr.list
%defattr(-,root,root)

%files nspr-devel -f mozilla-nspr-devel.list
%defattr(-,root,root)
%{prefix}/lib/pkgconfig/*
%{prefix}/bin/mozilla-config

%files nss -f mozilla-nss.list
%defattr(-,root,root)

%files nss-devel -f mozilla-nss-devel.list
%defattr(-,root,root)

%files mail -f mozilla-mail.list
%defattr(-,root,root)
/etc/X11/applnk/Internet/mozilla-mail.desktop
/etc/X11/applnk/Internet/mozilla-compose.desktop

%files psm -f mozilla-psm.list
%defattr(-,root,root)

%files chat -f mozilla-chat.list
%defattr(-,root,root)

%files js-debugger -f mozilla-js-debugger.list
%defattr(-,root,root)

%files dom-inspector -f mozilla-dom-inspector.list
%defattr(-,root,root)

%files devel -f mozilla-devel.list
%defattr(-,root,root)
%{prefix}/share/idl/mozilla-%{version}/*
%{prefix}/lib/mozilla-%{version}/xpcshell
%{prefix}/lib/mozilla-%{version}/xpidl
%{prefix}/lib/mozilla-%{version}/xpt_dump
%{prefix}/lib/mozilla-%{version}/xpt_link


%changelog
* Wed Jul 10 2002 Christopher Blizzard <blizzard@redhat.com>
- Use the components/*.dat files instead of component.reg both in
rebuild-databases.pl and in packaging.

* Mon Jul  1 2002 Chris Blizzard <blizzard@redhat.com>
- Move libs into the system that need to be there

* Tue Jun 25 2002 Christopher Blizzard <blizzard@redhat.com>
- Change mozilla-rebuild-databases.pl to remove compreg.dat as well as
  component.reg.

* Sun Jun 23 2002 Chris Blizzard <blizzard@redhat.com>
- Move nspr + nss back into /usr/lib

* Thu Jun 20 2002 Christopher Blizzard <blizzard@redhat.com>
- Time for a new changelog.
