#!/bin/sh

# this script checks over the packages before burning the master dropline cd
# to ensure everything is there and nothing is corrupt.

PACKAGE_DIR=/home/fflew/MORVA/gnome/packages
FILELIST=/home/fflew/MORVA/gnome/DroplineFiles2c

cd $PACKAGE_DIR
problems=""

word="foo"
while [ -n "$word" ]
do
	read word
	name=`echo $word | cut -d ':' -f 1`
	checksum=`echo $word | cut -d ':' -f 5`
	if [[ "$name" != "" && "$checksum" != "" ]]; then
		echo "checking $name..."
		if [ ! -e "$name" ]; then
			echo "$name is missing!"
			problems="$problems $name"
		else
			real_checksum=`md5sum "$name" | cut -d ' ' -f 1`
			if [ "$real_checksum" != "$checksum" ]; then
				echo "$name is corrupt!"
				problems="$problems $name"
			fi
		fi
	fi
done < $FILELIST

echo "problem packages:"
echo "$problems"
