/*  XMMS - ALSA output plugin
 *    Copyright (C) 2001      Matthieu Sozeau
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "alsa.h"
#include <dlfcn.h>

ALSAConfig alsa_cfg;

static gboolean alsa_is_loaded(void)
{
	int fd;
	char buf[4096];
	char *version;
	size_t count;
  
	fd = open("/proc/asound/version", O_RDONLY, 0);
	if (fd < 0) {
		return FALSE;
	}

	count = read(fd, buf, sizeof(buf) - 1);
	buf[count] = 0;
	close(fd);
	version = strstr(buf, " Version ");

	if (version == NULL) {
		return FALSE;
	}

	version += 9; /* strlen(" Version ") */

	/* The successor to 0.9 might be 0.10, not 1.0.... */
	if (strcmp(version, "0.9") > 0  ||  isdigit(version[3])) {
		return TRUE;
	} else {
		return FALSE;
	}
}

void alsa_init(void)
{
	ConfigFile *cfgfile;
	int warned = 0;
 
	memset(&alsa_cfg, 0, sizeof (ALSAConfig));

	alsa_cfg.audio_card = 0;  
	alsa_cfg.audio_device = 0;
	alsa_cfg.use_user_device = 1;
	alsa_cfg.user_device = "default";
	alsa_cfg.mixer_device = "PCM";
	alsa_cfg.buffer_time = 500;
	alsa_cfg.period_time = 50;
	alsa_cfg.debug = 0;
	alsa_cfg.mmap = 1;

	if ((cfgfile = xmms_cfg_open_default_file()))
	{
		xmms_cfg_read_int(cfgfile, "ALSA", "audio_card", &alsa_cfg.audio_card);
		xmms_cfg_read_int(cfgfile, "ALSA", "audio_device", &alsa_cfg.audio_device);
		xmms_cfg_read_boolean(cfgfile, "ALSA", "use_user_device", &alsa_cfg.use_user_device);
		xmms_cfg_read_string(cfgfile, "ALSA", "user_device", &alsa_cfg.user_device);
		xmms_cfg_read_string(cfgfile, "ALSA", "mixer_device", &alsa_cfg.mixer_device);
		xmms_cfg_read_int(cfgfile, "ALSA", "buffer_time", &alsa_cfg.buffer_time);
		xmms_cfg_read_int(cfgfile, "ALSA", "period_time", &alsa_cfg.period_time);
		xmms_cfg_read_boolean(cfgfile, "ALSA", "mmap", &alsa_cfg.mmap);

		xmms_cfg_read_boolean(cfgfile, "ALSA", "debug", &alsa_cfg.debug);
	}

	if (!alsa_is_loaded())
	{
		xmms_cfg_read_boolean(cfgfile, "ALSA", "warned", &warned);
	
		if(!warned)
		{
			g_warning("alsa-xmms: No ALSA 0.9+ kernel driver appears to be loaded");
			warned = 1;
		}
		xmms_cfg_write_boolean(cfgfile, "ALSA", "warned", warned);
		xmms_cfg_write_default_file(cfgfile);
		xmms_cfg_free(cfgfile);
		return;
	} else {
		// warn == 0 since we have ALSA but it could be missing later
		xmms_cfg_write_boolean(cfgfile, "ALSA", "warned", warned);		
		xmms_cfg_write_default_file(cfgfile);
		xmms_cfg_free(cfgfile);
	}
	

	if(dlopen("libasound.so.2", RTLD_NOW | RTLD_GLOBAL) == NULL)
	{
		printf("Cannot load alsa library: %s", dlerror());
		exit(-1);
	}
}
