/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Copyright 2002 Todd Kulesza
 *
 * Authors:
 * 		Todd Kulesza <todd@dropline.net>
 */

#ifndef _DRIVEL_H_
#define _DRIVEL_H_

#include <gtk/gtk.h>
#include <libgnomevfs/gnome-vfs.h>
#include <gconf/gconf-client.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <arpa/inet.h>

#include <config.h>

typedef struct _DrivelClient DrivelClient;
typedef struct _DrivelGConfData DrivelGConfData;
typedef struct _DrivelTime DrivelTime;
typedef struct _DrivelIDs DrivelIDs;
typedef struct _LJMenuItem LJMenuItem;
typedef struct _LJFriend LJFriend;
typedef struct _DrivelButtonVAList DrivelButtonVAList;

typedef enum
{
	REQUEST_CHECKFRIENDS,
	REQUEST_EDITEVENT,
	REQUEST_EDITFRIENDGROUPS,
	REQUEST_EDITFRIENDS,
	REQUEST_FRIENDOF,
	REQUEST_GETDAYCOUNTS,
	REQUEST_GETEVENTS,
	REQUEST_GETFRIENDGROUPS,
	REQUEST_GETFRIENDS,
	REQUEST_LOGIN,
	REQUEST_POSTEVENT,
	REQUEST_SYNCITEMS
} DrivelRequestType;

struct _DrivelTime
{
	gint year;
	gint month;
	gint day;
	gint hour;
	gint minute;
};

struct _LJFriend
{
	gchar *name;
	gchar *username;
	gchar *bg;
	gchar *fg;
	gboolean type;
	guint groupmask;
	gboolean friend;
	gboolean friend_of;
};

struct _LJMenuItem
{
	gchar *label;
	gchar *url;
	gushort menu_index;
	gushort item_index;
	gushort sub_menu;
};

struct _DrivelButtonVAList
{
	GtkWidget *button;
	GSList *entries;
	GSList *signals;
};

struct _DrivelIDs
{
	/* gconf ids */
	guint server_list_id;
	guint server_id;
	guint mood_id;
	guint music_id;
	guint picture_id;
	guint security_id;
	guint comment_id;
	guint autoformat_id;
	guint proxy_id;
	guint proxy_url_id;
	guint proxy_port_id;
	guint proxy_user_id;
	guint proxy_pass_id;
	guint tray_id;
	
	/* loop ids */
	guint loop_checkfriends_id;
};

struct _DrivelGConfData
{
	/* login window preferences */
	gchar *user;
	gchar *password;
	gchar *save_password;
	gchar *autologin;
	
	/* journal window default preferences */
	gchar *default_server_list;
	gchar *default_server;
	gchar *default_mood;
	gchar *default_music;
	gchar *default_picture;
	gchar *default_security;
	gchar *default_comment;
	gchar *default_autoformat;
	
	/* proxy preferencess */
	gchar *proxy;
	gchar *proxy_url;
	gchar *proxy_port;
	gchar *proxy_user;
	gchar *proxy_pass;
	
	/* notification area preferences */
	gchar *tray;
	
	/* entry position and size */
	gchar *entry_x;
	gchar *entry_y;
	gchar *entry_height;
	gchar *entry_width;
	gchar *entry_max;
	gchar *min_start;
	gchar *min_post;
};

struct _DrivelClient
{
	GtkWidget *login_window;
	GtkWidget *journal_window;
	GtkWidget *current_window;
	GtkWidget *friends_list_window;
	GtkWidget *edit_history_window;
	
	/* login window widgets */
	GtkWidget *login_name;
	GtkWidget *login_password;
	GtkWidget *save_password;
	GtkWidget *autologin;
	GtkWidget *login_button;
	GtkWidget *login_menu;
	GtkWidget *sign_up_button;
	GtkWidget *sign_up_menu;
	
	/* journal window widgets */
	GtkWidget *journal_subject;
	GtkWidget *journal_mood;
	GtkWidget *journal_music;
	GtkWidget *journal_text;
	GtkWidget *journal_security;
	GtkWidget *journal_picture;
	GtkWidget *journal_comment;
	GtkWidget *journal_autoformat;
	GtkWidget *options_frame;
	GtkTextBuffer *buffer;
	GtkWidget *preferences_mood;
	GtkWidget *journal_post;
	GtkWidget *journal_options;
	GtkWidget *edit_delete;
	GtkWidget *edit_save;
	GtkWidget *edit_cancel;
	GtkWidget *menu_cut;
	GtkWidget *menu_copy;
	GtkWidget *menu_paste;
	
	/* preferences widgets */
	GtkWidget *pref_server_list;
	GtkWidget *pref_server;
	GtkWidget *pref_server_label;
	GtkWidget *pref_proxy_url;
	GtkWidget *pref_proxy_url_label;
	GtkWidget *pref_proxy_port;
	GtkWidget *pref_proxy_port_label;
	GtkWidget *pref_proxy_user;
	GtkWidget *pref_proxy_user_label;
	GtkWidget *pref_proxy_pass;
	GtkWidget *pref_proxy_pass_label;
	
	/* friends dialog */
	GtkListStore *list_store;
	GtkWidget *friend_list;
	GtkWidget *friend_edit;
	GtkWidget *friend_remove;
	GtkWidget *dialog_add_friend;
	GtkWidget *dialog_add_fg;
	GtkWidget *dialog_add_bg;
	GtkWidget *dialog_add_ok;
	GtkWidget *dialog_edit_friend;
	GtkWidget *dialog_edit_fg;
	GtkWidget *dialog_edit_bg;
	
	/* history dialog */
	GtkListStore *history_store;
	GtkWidget *history_list;
	GtkWidget *history_calendar;
	GtkWidget *history_edit;
	
	/* insert link dialog */
	GtkWidget *link_text;
	GtkWidget *link_text_label;
	GtkWidget *link_url;
	GtkWidget *link_url_label;
	GtkWidget *link_user;
	GtkWidget *link_user_label;
	GtkWidget *link_ok;
	DrivelButtonVAList *link_bval;
	
	/* insert image dialog */
	GtkWidget *image_url;
	GtkWidget *image_height;
	GtkWidget *image_width;
	GtkWidget *image_alt;
	GtkWidget *image_ok;
	DrivelButtonVAList *image_bval;
	
	GtkWidget *message_dialog;
	GtkWidget *open_dialog;
	GtkWidget *save_dialog;
	GtkWidget *network_progress;
	
	/* network data */
	gchar *server;
	gchar *server_proper_format;
	gchar *proxy_proper_format;
	GSList *send_data;
	GSList *request_types;
	gchar *read_data;
	gint read_len;
	gboolean sending;
	DrivelRequestType request_type;
	GHashTable *vars;
	struct sockaddr_in server_addr;
	gint socket;
	GIOChannel *channel;
	guint tag_read;
	guint tag_write;
	guint tag_closed;
	guint tag_autosave;
	GAsyncQueue *progress_queue;
	GAsyncQueue *data_queue;
	gint time_since_checkfriends;
	gchar *lastupdate;
	gboolean checking_friends;
	gboolean friends_update;
	
	GConfClient *client;
	DrivelGConfData *gconf;
	
	/* user-specific settings */
	gchar *name;
	gchar *username;
	gchar *password;
	gboolean use_fast_servers;
	GHashTable *picture_keywords;
	GHashTable *mood_icons;
	GSList *mood_list;
	gint pictures;
	gint moods;
	gint journals;
	GSList *journal_list;
	gchar *active_journal;
	gchar *itemid;
	gboolean modified;
	gboolean modified_autosave;
	gint response;
	gboolean proxy;
	gchar *proxy_url;
	gint proxy_port;
	GSList *menu_list;
	GSList *friends_list;
	gchar *login_send_data;
	gboolean invalid_input;
	gboolean edit_entry;
	GSList *window_list;
	gboolean tray;

	DrivelTime time;
	DrivelIDs id;
};

void
display_error_dialog (DrivelClient *dc, const gchar *mesg);

void
drivel_button_list_clear (DrivelButtonVAList *bval);

void
fill_time (DrivelClient *dc);

void
drivel_push_current_window (DrivelClient *dc, GtkWidget *window);

GtkWidget *
drivel_pop_current_window (DrivelClient *dc);

GtkWidget *
drivel_get_current_window (GSList *list);

void
hash_table_item_free (gpointer data);

void
hash_table_clear (GHashTable *table);

void
drivel_gconf_data_fill (DrivelGConfData *data, const gchar *username, GConfClient *client, DrivelIDs *id, DrivelClient *dc);

void
drivel_fill_journal_null (DrivelClient *dc);

gint
string_compare (gconstpointer a, gconstpointer b);

gboolean
sort_compare (gconstpointer a, gconstpointer b);

gboolean
validate_username (const gchar *username);

void
check_mem (const gchar *title);

gchar *
get_default_text (GConfClient *client, const gchar *key, const gchar *standard_text);

void
list_free_item (gpointer data, gpointer user_data);

void
menu_list_free_item (gpointer data, gpointer user_data);

void
friends_list_free_item (gpointer data, gpointer user_data);

gint
compare_usernames (gconstpointer a, gconstpointer b);

#endif
