"""
Slackware package handler for Deskbar
by Scott Harmon <harmon at ksu dot edu>

Version 1.0 (November 23 2005)

Installation:
1) copy to ~/.gnome2/deskbar-applet/handlers and you're done!

Licensed under the GNU GPL
"""

from gettext import gettext as _

import gtk
import glob
import gnomevfs
import deskbar.handler
#import traceback

HANDLERS = {
        "SlackwarePackageHandler" : {
                "name": _("Spack"),
                "description": _("Displays installed packages"),
        }
}

PACKDIR = '/var/log/packages/'

class SlackwarePackageMatch(deskbar.handler.Match):
        def __init__(self, backend, result):
                deskbar.handler.Match.__init__(self, backend, result)
                self._result = result

        def action(self, text=None):
                for clipboard in ['CLIPBOARD', 'PRIMARY']:
                        gtk.clipboard_get(clipboard).set_text(self._result)

        def get_verb(self):
                return _("Copy <b>%(name)s</b> to clipboard")

        def get_hash(self, text=None):
                return self._result

class SlackwarePackageHandler(deskbar.handler.Handler):
        def __init__(self):
                deskbar.handler.Handler.__init__(self, "pkgtool.png")

        def query(self, query, max=5):
                try:
			
			result = []
			query = PACKDIR + '*' + query + '*'
			query = glob.glob(query)
			for file in query:
				result.append(SlackwarePackageMatch(self, file[len(PACKDIR):]))
				if len(result) == max:
					break
                        return result
                except:
                        #print traceback.format_exc()
                        return []
