#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/rc.d/rc.udev.new
config etc/udev/rules.d/udev.rules.new

# backupfile() functions robbed from Scott's GDM pack.  :)
backupfile() {
        local filename=$1
        local num="1"
        local newfilename=$filename-dl-backup-$num
        while [ -e $newfilename ]; do
                num="$(( $num + 1 ))"
                newfilename=$filename-dl-backup-$num
        done
        cp $filename $newfilename
}

# Backup the old udev.rules...  Sorry folks, but this has to be
# replaced for things to "just work".

if [ -e  $ROOT/etc/udev/rules.d/udev.rules.new ]; then
        # backup old udev.rules
        backupfile $ROOT/etc/udev/rules.d/udev.rules
        mv $ROOT/etc/udev/rules.d/udev.rules.new $ROOT/etc/udev/rules.d/udev.rules
fi


# Disabling the hotplug firmware loader in favor of udev's.  Another thing
# that must be done to make things "just work".  Sorry, but Slackware's
# Hotplug and udev packs are just *way too broken*.

chmod -x $ROOT/etc/hotplug/firmware.agent
