## insertroleaccount accountname [uid] [gid]
##   This routine will create a role account on the system with the uid (and
##   optional gid) specified.  It will check to make sure that the id names
##   are not duplicated but relies on useradd and groupadd to emit errors if
##   the numeric ids would be non-unique.  Although they are optional, it is
##   recommended that the uid and gid fields be specified since Slackware
##   makes an assumption that role accounts will have ids below 100, and left
##   unspecified useradd will pick a uid above 1000.
##
insertroleaccount ()
{ 
  local rolename=$1 uid=$2 gid=${3:-$2}
  local tmp exists

  while read ; do
    tmp=`echo $REPLY | cut -d: -f1`
    if [ "$tmp" = "$rolename" ]; then
      exists='y'
      break
    fi
  done < $ROOT/etc/group

  if [ "$exists" != 'y' ]; then
    groupadd ${gid:+-g $gid} $rolename
    exists='n'
  fi

  while read ; do
    tmp=`echo $REPLY | cut -d: -f1`
    if [ "$tmp" = "$rolename" ]; then
      exists='y'
      break
    fi
  done < $ROOT/etc/passwd

  if [ "$exists" != 'y' ]; then
    useradd ${uid:+-u $uid} $rolename -g $rolename -s /bin/false -d / -c "$rolename role account"
  fi
}

insertroleaccount messagebus 70 70

# Special thanks to Richard Thomas of the NLUG mailing list for helping to
# sort out this annoying problem.
sed -i -e '/^#\ To\ disable\ dbus/,/^fi/d' $ROOT/etc/rc.d/rc.local
