"""
Slackware package handler for Deskbar
by Scott Harmon <harmon at ksu dot edu>

Version 1.1 (March 20 2006)

Installation:
1) copy to ~/.gnome2/deskbar-applet/handlers and you're done!

Licensed under the GNU GPL
"""

from gettext import gettext as _

import gtk
import glob
import gnomevfs
import deskbar, deskbar.Indexer, deskbar.Utils
import deskbar.Handler, deskbar.gnomedesktop
#import traceback

HANDLERS = {
        "SlackwarePackageHandler" : {
                "name": _("Spack"),
                "description": _("Displays installed packages"),
        },
}

PACKDIR = '/var/log/packages/'

class SlackwarePackageMatch(deskbar.Match.Match):
        def __init__(self, backend, name=None, **args):
		deskbar.Match.Match.__init__(self, backend, name=name, **args)
		self._icon = deskbar.Utils.load_icon_for_desktop_icon(self.icon)


        def action(self, text=None):
                for clipboard in ['CLIPBOARD', 'PRIMARY']:
                        gtk.clipboard_get(clipboard).set_text(self.name)

	def get_category(self):
		return "actions"

        def get_verb(self):
                return _("Copy <b>%(name)s</b> to clipboard")

        def get_hash(self, text=None):
                return self.name

class SlackwarePackageHandler(deskbar.Handler.Handler):
        def __init__(self):
                deskbar.Handler.Handler.__init__(self, "pkgtool.png")

        def query(self, query):
                try:
			result = []
			query = PACKDIR + '*' + query + '*'
			query = glob.glob(query)
			for file in query:
				result.append(SlackwarePackageMatch(self, file[len(PACKDIR):]))
				if len(result) == deskbar.DEFAULT_RESULTS_PER_HANDLER:
					break
                        return result
                except:
                        #print traceback.format_exc()
                        return []
