config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}

# The login.defs has to be replaced to avoid errors...
config etc/login.defs
config etc/login.defs.new
config etc/pam.d/login.new
config etc/pam.d/passwd.new
config etc/pam.d/shadow.new
config etc/pam.d/su.new
config etc/pam.d/useradd.new
config var/log/faillog.new
rm -f var/log/faillog.new

# Added for shadow 4.0.7
config etc/pam.d/chage.new
config etc/pam.d/chfn.new
config etc/pam.d/chpasswd.new
config etc/pam.d/chsh.new
config etc/pam.d/groupadd.new
config etc/pam.d/groupdel.new
config etc/pam.d/groupmod.new
config etc/pam.d/newusers.new
config etc/pam.d/userdel.new
config etc/pam.d/usermod.new

( cd bin ; rm -rf sulogin )
( cd bin ; ln -sf /sbin/sulogin sulogin )
if [ -r sbin/adduser ]; then 
  rm -f sbin/adduser
fi
( cd usr/man/man8 ; rm -rf pwunconv.8.gz )
( cd usr/man/man8 ; ln -sf pwconv.8.gz pwunconv.8.gz )
( cd usr/man/man1 ; rm -rf sg.1.gz )
( cd usr/man/man1 ; ln -sf newgrp.1.gz sg.1.gz )
( cd usr/bin ; rm -rf sg )
( cd usr/bin ; ln -sf newgrp sg )
( cd usr/sbin ; rm -rf vigr )
( cd usr/sbin ; ln -sf vipw vigr )
( cd usr/man/man8 ; rm -rf vigr.8.gz )
( cd usr/man/man8 ; ln -sf vipw.8.gz vigr.8.gz )
