## insertroleaccount accountname [uid] [gid]
##   This routine will create a role account on the system with the uid (and
##   optional gid) specified.  It will check to make sure that the id names
##   are not duplicated but relies on useradd and groupadd to emit errors if
##   the numeric ids would be non-unique.  Although they are optional, it is
##   recommended that the uid and gid fields be specified since Slackware
##   makes an assumption that role accounts will have ids below 100, and left
##   unspecified useradd will pick a uid above 1000.
##
insertroleaccount ()
{ 
  local rolename=$1 uid=$2 gid=${3:-$2}
  local tmp exists

  while read ; do
    tmp=`echo $REPLY | cut -d: -f1`
    if [ "$tmp" = "$rolename" ]; then
      exists='y'
      break
    fi
  done < $ROOT/etc/group

  if [ "$exists" != 'y' ]; then
    groupadd ${gid:+-g $gid} $rolename
    exists='n'
  fi

  while read ; do
    tmp=`echo $REPLY | cut -d: -f1`
    if [ "$tmp" = "$rolename" ]; then
      exists='y'
      break
    fi
  done < $ROOT/etc/passwd

  if [ "$exists" != 'y' ]; then
    useradd ${uid:+-u $uid} $rolename -g $rolename -s /bin/false -d / -c "$rolename role account"
  fi
}

insertroleaccount avahi 72 72

backupfile() {
        local filename=$1
        local num="1"
        local newfilename=$filename-dl-backup-$num
        while [ -e $newfilename ]; do
                num="$(( $num + 1 ))"
                newfilename=$filename-dl-backup-$num
        done
        cp $filename $newfilename
}

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/nsswitch.conf.new

# Backup the old nsswitch.conf file...
if [ -e  $ROOT/etc/nsswitch.conf.new ]; then
        # backup old nsswitch.conf
        backupfile $ROOT/etc/nsswitch.conf
        mv $ROOT/etc/nsswitch.conf.new $ROOT/etc/nsswitch.conf
fi
