%define name       gaim
%define version    0.60cvs
%define release    1
%define prefix     /usr
%define sysconfdir /etc

# This stuff makes things install into the directories that LFS wants.
# Ugly, and I don't know why rpm doesn't put them in the right places,
# but whatever.
%{expand:%%define share %(if [ -d %{prefix}/share/man ]; then echo /share ; else echo %%{nil} ; fi)}
%ifos linux
%define CONFIG_FLAGS --prefix=%prefix --infodir='%{prefix}%{share}/info' --mandir='%{prefix}%{share}/man'
%else
%define CONFIG_FLAGS --prefix=%prefix
%endif

Summary:    A Gtk+ based multiprotocol instant messaging client
Name:       %{name}
Version:    %{version}
Release:    %{release}
Epoch:      1
License:    GPL
Group:      Applications/Internet
Vendor:     Pimpin' Penguins
Url:        http://gaim.sf.net/
Source:     %{name}-%{version}.tar.gz
Packager:   Rob Flynn <rob@marko.net>
BuildRoot:  /var/tmp/%{name}-%{version}-root
Requires:   gtk2 >= 2.0.0
Prefix:     %{prefix}

%description
Gaim allows you to talk to anyone using a variety of messaging 
protocols, including AIM (Oscar and TOC), ICQ, IRC, Yahoo!, 
MSN Messenger, Jabber, Gadu-Gadu, Napster, and Zephyr.  These 
protocols are implemented using a modular, easy to use design.  
To use a protocol, just load the plugin for it.

Gaim supports many common features of other clients, as well as many 
unique features, such as perl scripting and C plugins.

Gaim is NOT affiliated with or endorsed by AOL.

%prep
%setup

%build
CFLAGS="$RPM_OPT_FLAGS" ./configure %{CONFIG_FLAGS} --disable-artsc
make

%install
if [ -d $RPM_BUILD_ROOT ]; then rm -r $RPM_BUILD_ROOT; fi;
make DESTDIR=$RPM_BUILD_ROOT prefix=%{prefix} sysconfdir=%{sysconfdir} install

%files
%defattr(-, root, root)

%doc doc/the_penguin.txt doc/CREDITS NEWS COPYING AUTHORS
%doc doc/FAQ README ChangeLog plugins/PERL-HOWTO HACKING

%attr(755, root, root) %{_libdir}/gaim/*

%{_bindir}/*
%{_mandir}/man1/gaim.1.*
%{_datadir}/locale/*/*/*
%{_datadir}/pixmaps/*
%{_datadir}/pixmaps/gaim/*
%{_datadir}/pixmaps/gaim/dialogs/*
%{_datadir}/pixmaps/gaim/buttons/*
%{_datadir}/applications/gaim.desktop

%clean
rm -r $RPM_BUILD_ROOT

%changelog
* Mon Jun 24 2002 Rob Flynn <rob@marko.net> (0.59 release)
- Hungarian translation added (Thanks, Sutto Zoltan)
- Swedish translation updated (Thanks, Christian Rose)
- Spanish translation updated (Thanks, Alex)
- Traditional Chinese translation updated (Thanks, Paladin Liu)
- Czech translation added (Thanks, Honza)
- Polish translation updated (Thanks Przemyslaw Sulek)
- Squashed a bug in buddy right-click menu handling that crashed Gaim.  In the process: found and eliminated some memory leaks.
- Fixed a significant applet leak
- Can now change Jabber password on server (Thanks, Nathan Walp)
- Certain types of Jabber presence errors no longer falsely show a buddy on-line.  Instead now a "broken light-bulb" icon is shown and the error status is available via "Get Away Msg"  (Thanks and a tip o' the hat to Christian Hammond for the graphic)
- Conversation struct has pointer to toolbar (thanks Brent Priddy and Paul Miller)
- Zephyr fixes (thanks, Arun A. Tharuvai)
- Aliases in buddy ticker
- Perl scripts can play Gaim sounds (thanks Andrew Rodland)
- Internal sounds can be played by commands (thanks Lex Spoon)
- Auto-login item in applet menu (thanks Chris Boyle)
- Fixed MSN "Unkown Error Code", "Already there", and Already in opposite list" errors
- Changed "Play sound" button to "Mute" button
- You can now have "reserved" chars in IM and proxy passwords
- Jabber now has typing notification  (Thanks, Nathan Walp)
- Improved support for Jabber resources  (Thanks, Nathan Walp)
- Fixed problem with Gaim crashing on non-ASCII Jabber buddy aliases (Jabber "name" attribute) chars  (Thanks, Ho-seok Lee)
- Plugged memory leaks in Jabber plug-in
- Fixed problem with Jabber away status not being propagated to conference rooms for jabberd (server) v1.4.2 and above
- Chat room buddy lists are now sorted independent of case
- Added capability for protocol-specific edit buddy menu entries
- Can now remove a Jabber buddy roster item from the server entirely
- Gaim can now handle messages from Mac ICQ and Miranda ICQ (Thanks, Mark Doliner)
- Added Mozilla to browser options and changed KFM to  Konqueror.
- Can now set the server and port for MSN and Napster
- MSN Internationalization (Thanks Felipe Contreras and countless, countless others)
- E-mail addresses are no longer truncated when there is a '.' at the end.

* Mon May 13 2002 Rob Flynn <rob@marko.net> (0.58 release)
- Bulgarian translation added (Thanks, Igel Itzo)
- Taiwanese translation added (Thanks, Paladin Liu)
- Better applet transparency
- Option to raise buddy list on signons/signoffs
- Formatting of incoming MSN messages	
- Get Info from menu multiple-account-aware (thanks Brian Bernas)
- Hide and unhide functions for the filectl plugin. (Thanks, Ari Pollak)
- Added helpful stuff to the Help menu.
- Self-aliasing from the account editor.
- Better selection in GtkIMHtml (Thanks Ben Miller)
- A warning when your OSCAR buddy list is too long (Thanks, Mark Doliner)
- ICQ status messages in OSCAR (Thanks, Mark Doliner)
- Play sound when your name is said in a chat
- Approval dialog for Jabber when somebody wants to subscribe to user's presence. Also gives user the opportunity to add that buddy if not already on the user's buddy list.
- Jabber "Change buddy group" roster synchronization now works again. (This was unknowningly broken when the "out-sourced" Jabber libs were upgraded in 0.56)
- Invalid Jabber I.D.'s no longer crash Gaim.  User now notified with pop-up's.
- Jabber Buddy sign-on time support, added in 0.57, removed until and unless an inconsistancy can be resolved. (Thanks, Nathan Walp)
- Bug-fix for potential buffer overflow in Jabber plugin. (Thanks, rwscott)
- Tempfiles used for secure MSN/HotMail login (added in 0.57) are now themselves created securely.
- Secure MSN logins (added in 0.57) no longer blow up on Solaris.
- Timezone support improved.

* Thu Apr 25 2002 Rob Flynn <rob@marko.net (0.57 release)
- New authorization method for Yahoo!
- Polish translation updated (Thanks Przemyslaw Sulek)
- Jabber will tell you when your buddies signed on (Thanks Nathan Walp)
- Danish translation added (Thanks, Sarauw Hansen)
- Finnish translation update (Thanks, Tero Kuusela)
- Japanese translation added (Thanks, Ryosuke Kutsuna)
- Jabber improvements (Thanks, Nathan Walp)
- More keyboard shortcuts
- event_chat_recv takes char**'s, and event_im_recv takes a *guint32 for flags
- Secure hotmail login for MSN (thanks for the tips, Scott Werndorfer)

* Thu Apr 11 2002 Rob Flynn <rob@marko.net (0.56 release)
- German translation update (Thanks Karsten Weiss)
- Shell-like send history binded to Ctrl-Up and Ctrl-Down
- Russian Translation Updated (thanks Grigory Bakunov)
- libjabber upgraded to most recent stable version
- Buddylist looks a little better
- Fixed MSN privacy settings
- Group deletion fix (Thanks Mark Doliner)
- Alias/Group syncronization for Jabber (Thanks JSeymour)
- Fixed broken signal handling in gdm-started GNOME sessions (Thanks Jim Seymour, Vann, Robert McQueen)
- Oscar group syncronization (Thanks, Mark Doliner)
- ICQ Authorization via Oscar (Thanks, Mark Doliner)


* Fri Mar 29 2002 Rob Flynn <rob@marko.net> (0.55 release)
- Jabber improvements (Thanks Jim Seymour)
- Various sound cleanups (Thanks Robert McQueen)
- Login process shown in single window (Thanks Michael Golden)
- Can reorder your accounts in the account editor (Thanks Luke Schierer)
- Updated Dutch translation
- Shows "mobile" icon for Oscar buddies using mobile devices (Thanks Mark Doliner)
- Fixed bug in MSN smilies that crashed PPC (and other?) platforms
- Updated Polish Translation (Thanks Przemyslaw Sulek)
- Updated Spanish Translation (Thanks Amaya)
- Updated French translation
- Updated Finnish translation (Thanks Tero Kuusela)
- HTTP Proxy settings now HTTP compliant (Thanks Robert McQueen)
- Speling corections (Thanks Tero Kuusela)
- Oscar list icon fixes (Thanks Mark Doliner)
- Oscar idle times work again (Thanks Mark Doliner)
- Protocol icons on Edit Buddies tab (Thanks Christian Hammond)

* Thu Mar 14 2002 Rob Flynn <rob@marko.net> (0.54 release)
- Compiles without GdkPixbuf again
- GtkIMHtml will refresh when you set a new GTK+ theme
- Improved Yahoo! typing notification (thanks Brian Macke)
- Prompt to authorize MSN buddies who added you while you were offline (Thanks Jason Willis)
- Option to globally disable Buddy Icon animation (Thanks Luke Schierer)
- Numerous bugfixes
- Yahoo! will tell you when your buddies are playing Yahoo! games and give you the ability to join them
- Yahoo! can receive offline messages
- IRC can do DCC chat.
- IRC will convert HTML formatting to mIRC formatting.
- Buddylist tab placement option (Thanks Jason Willis)
- Protocol specific smiley faces
- Italian translation added
- IM Image sending

* Fri Feb 28 2002 Rob Flynn <rob@marko.net> (0.53 release)
- Updated Polish Translation (thanks Przemyslaw Sulek)
- Slovak translation added (Thanks Daniel Rezny)
- Minor bug fixes re: queued away messages
- Better buddy icon transparency (for real this time ;-))
- Ability to change formatting of Oscar screen name
- Better selection in HTML widget (Thanks BMiller)
- New icons for ICQ (Thanks Kevin Miller)
- Editable buddy pounces (Thanks Jason Willis)
- Server side buddy lists in Oscar (Thanks KingAnt :-))
- Fix for the chatlist plugin
- Typing Notification (AIM Direct Connect, Yahoo, MSN)
- IM Images (Receive Only)
- Prettier GtkImHtml selection

* Sun Feb 17 2002 Rob Flynn <rob@marko.net> (0.52 release)
- Better buddy icon transparency (thanks SeanEgan)
- Updated Polish Translation (thanks Przemyslaw Sulek)
- Fixed a little bug with connecting via proxy (thanks for reminding me of this, Manish Singh)
- Updated Simplified Chinese Translation (Thanks Rocky S. Lee)
- Updated German Translation (Thanks Karsten Weiss)
- Yahoo! Messenger works again
- MSN Works again
- Can register a new user with a Jabber Server (JSeymour)
- Can now set Jabber vCards (JSeymour)
- Jabber vCards are now shown in their entirety (JSeymour)
- Various jabber bug fixes/enhancements (JSeymour)

* Thu Jan 24 2002 Rob Flynn <rob@marko.net> (0.51 release)
- Arrow buttons in log viewer and some other dialogs work (thanks Ben Miller)
- Option to only send auto-response while idle (thanks Sean Egan)
- Control time between sending auto-responses (thanks Mark Doliner)
- Should be able to sign on to Oscar using Mac OS X (thanks Fingolfin, Vincas Ciziunas, et al.)
- Finnish translation added (Thanks Tero Kuusela)
- Updated French Translation (Thanks sebfrance)

* Thu Dec 13 2001 Rob Flynn <rob@marko.net> (0.50 release)
- Updated polish translation (Thanks Przemyslaw Sulek)
- Able to import GnomeICU contact lists
- Galeon as browser option (Thanks Rob McQueen)
- IRC /list, /invite (Thanks Sean Egan)
- Added swedish translation (Thanks Christian Rose)
- Option to have IMs and Chats tabbed in same window
- Finally put the lagmeter plugin out of its misery and removed it. (/me dances on its grave.)

* Thu Nov 29 2001 Rob Flynn <rob@marko.net> (0.49 release)
- Can compile against GTK+ 2.0 (version 1.3.10/1.3.11)
- Confirm before removing buddies
- Updated Russian translation (thanks Grigory Bakunov)
- Updated Korean translation (thanks Ho-seok Lee, also for resized ICQ icons)
- Updated Dutch translation (thanks Floris Eshuis)
- Yahoo updates (thanks Brian Macke)
- Jabber updates
- Zephyr updates (thanks Arun A Tharuvai)
- Gadu-Gadu updates (thanks Arkadiusz Miskiewicz)
- Option to show aliases in conversation tabs
- Option to hide windows after sending messages
- licq2gaim.pl conversion script (thanks Arturo Cisneros, Jr.)

* Thu Nov 18 2001 Rob Flynn <rob@marko.net> (0.48 release)
- Right-click on links to open/copy URL
- Yahoo changes
- Oscar can send/receive offline messages in ICQ. Since the "real" ICQ protocol isn't working too well it's recommended that you use Oscar for ICQ.

* Thu Nov 01 2001 Rob Flynn <rob@marko.net> (0.47 release)
- Better font loading (pays attention to charset now) (thanks Arkadiusz Miskiewicz)
- Better recoding in Gadu-Gadu (thanks Arkadiusz Miskiewicz)
- Open Mail button for when you get new mail (Yahoo and MSN)
- New buddy pounce option: Popup Notification
- When adding a buddy, the groups list now updates when you switch accounts.
- When creating a new buddy pounce, gaim now automagically selects "on away" or "on idle", if the user is away or idle.
- Add Opera to the available browsers (thanks Brian Enigma)
- Improved log viewer (thanks to Ben Miller)
- When you are queueing away messages, double clicking on a buddy's name will cause the messages for that name to be dequeued.
- You can choose which sound player you use at run-time (thanks Ben Miller)
- When someone adds you to their buddy list, it asks if you want to add them as well (Yahoo, ICQ, and MSN) (thanks Nathan Walp)
- Option to grey idle buddies (thanks Nathan Walp)
- MSN Privacy Options
- In MSN you can set a person's alias to their "friendly name" by right-click on their name while they're online.
- IRC can do /WHOIS
- The usual bug fixes and memory leak plugs
- Added Dutch translation
- Updated Korean translation

* Thu Oct 18 2001 Rob Flynn <rob@marko.net> (0.46 release)
- New applet icons (courtesy David Raeman)
- ICQ works on big-endian platforms, e.g. sparc and ppc (thanks to Nathan Walp and Ben Miller)
- Better applet icon drawing (thanks to Ari Pollak)
- An extraordinary number of bug fixes
- Updated Korean translation
- Ability to stop animation on buddy icons, restart animation, hide certain buddy icons, and save people's buddy icons, all through a right-click menu
- Event handlers in perl passed arguments as elements of an array rather than all concatenated as a string, making perl much easier to use (thanks Dennis Lambe Jr.)
- Can pass an argument to timeout_handlers in perl (thanks Artem Litvinovich)
- Redesigned Modify Account window (thanks Sean Egan)
- Add buddy dialog now lets you select which protocol to add the buddy to
- Pressing 'signon' on the first screen for accounts that do not require passwords no longer incorrectly displays an error message.

* Thu Oct 04 2001 Rob Flynn <rob@marko.net> (0.45 release)
- New plugin event: event_chat_send_invite
- Major updates to the perl system (reread PERL-HOWTO and SIGNALS)
- Major updates to event_chat_* events for plugins (reread SIGNALS)
- Some GtkIMHtml improvements
- Various bugfixes
- Nick Highlighting in chat
- Tab-completion for nicks in chat (thanks to Sean Egan)
- Large internal reworkings
- New Protocol: Gadu-Gadu, written by Arkadiusz Miskiewicz
- Can choose buddy icon to send (for Oscar)
- New Translation: Polish translation by Przemysaw Suek

* Thu Sep 20 2001 Rob Flynn <rob@marko.net> (0.44 release)
- More sane scaling of buddy icons (intelligently scale to either 48x48 or 50x50 depending on icon)
- Have you ever had it happen where you cancel a login and Gaim starts using all the available processing power? I think I fixed that.
- Temporarily removed Jabber user registration, which wasn't working anyway.
- Added a spiffy Help button
- Wrote a plugin for all those people who miss having the chat rooms in their buddy lists (chatlist.so)
- Updated libfaim
- Added drop down selection to chat invitation
- Improved the look of the chat invitation dialog
- Improved the look of the proxy preferences
- event_im_recv and event_im_display_rcvd passed whether the message received was auto-response (see SIGNALS)
- IRC fixes (largly copied from X-Chat)
- Internal change to how preferences are stored
- Other bug fixes
- Option to hide buddy icons

* Thu Sep 06 2001 Rob Flynn <rob@marko.net> (0.43 release)
- Updated German Translation (thanks Daniel Seifert)
- Can change friendly name in MSN again
- Bug fixes
- Auto-reconnect plugin has exponential timeout (i.e. it tries after 8 seconds, then 16, then 32, etc. up to 17 minutes)
- Removed file transfer things from Napster. It didn't work well anyway. It'll be back eventually. (Does anyone even use napster anymore?)
