/* GKrellM
|  Copyright (C) 1999-2003 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.  Version 2 is in the
|  COPYRIGHT file in the top level directory of this distribution.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <glib.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <time.h>

#if (defined(__sun) && defined(__SVR4)) || defined(SOLARIS_8)
#define __solaris__
#endif

#if !defined(WIN32)
#include <unistd.h>
#include <utime.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/ioctl.h>
#include <pwd.h>
#include <grp.h>
#if defined(__solaris__)
#include <sys/filio.h>
#endif
#include <sys/select.h>
#include <sys/wait.h>
#else
#define SIGTSTP SIGTERM
#define ioctl ioctlsocket
#include "../src/win32.h"
#if defined(_WINDOWS)
#include "resource.h"
#endif
#endif

#include <sys/stat.h>
#include <sys/types.h>
#include <locale.h>
#include <signal.h>
#include <errno.h>

#include "../src/gkrellm-sysdeps.h"

#if defined(__linux__)
#if defined(__GLIBC__) && ((__GLIBC__>2)||(__GLIBC__==2 && __GLIBC_MINOR__>=1))
#define HAVE_GETADDRINFO	1
#endif
#endif

#if defined(__FreeBSD__)
#include <sys/param.h>
#if __FreeBSD_version >= 400000
#define HAVE_GETADDRINFO	1
#endif
#endif

#if defined(__NetBSD__) || defined(__OpenBSD__)
#define HAVE_GETADDRINFO	1
#endif

#if defined(__solaris__)
# include <netconfig.h>
# if defined(NC_INET6)
#  define HAVE_GETADDRINFO	1
# endif
#endif

#if defined(__APPLE__)
# ifndef socklen_t
#  define socklen_t int
# endif
#define HAVE_GETADDRINFO   1
#endif

#ifndef	NI_WITHSCOPEID
#define	NI_WITHSCOPEID	0
#endif

#if !defined(__FreeBSD__) && !defined(__linux__) && !defined(__NetBSD__) \
    && !defined(__OpenBSD__) && !defined(__solaris__) && !defined(WIN32) \
    && !defined(__APPLE__)
#define  USE_LIBGTOP
#endif

extern int	errno;

#if !defined(PACKAGE_D)
#define	PACKAGE_D	"gkrellmd"
#endif

/* Internationalization support.
*/
#if defined (ENABLE_NLS)
#include <libintl.h>
#	undef _
#	define _(String) dgettext(PACKAGE_D,String)
#   if defined(gettext_noop)
#       define N_(String) gettext_noop(String)
#   else
#       define N_(String) (String)
#   endif   /* gettext_noop */
#else
#   define _(String) (String)
#   define N_(String) (String)
#   define textdomain(String) (String)
#   define gettext(String) (String)
#   define dgettext(Domain,String) (String)
#   define dcgettext(Domain,String,Type) (String)
#   define bindtextdomain(Domain,Directory) (Domain) 
#endif  /* ENABLE_NLS */

/* -------------------------------------------------------------------
*/
#define GKRELLMD_VERSION_MAJOR   2
#define GKRELLMD_VERSION_MINOR   1
#define GKRELLMD_VERSION_REV     16
#define GKRELLMD_EXTRAVERSION    ""

#define GKRELLMD_CONFIG     "gkrellmd.conf"

#if !defined(WIN32)
#define	GKRELLMD_SYS_ETC	"/etc"
#define GKRELLMD_LOCAL_ETC	"/usr/local/etc"
#endif

#define DEBUG_SYSDEP	0x1
#define DEBUG_MAIL		0x10
#define DEBUG_NET		0x20
#define DEBUG_TIMER		0x40
#define DEBUG_SENSORS	0x80
#define DEBUG_REMOTE	0x100
#define DEBUG_GUI		0x1000

#define SENSOR_TEMPERATURE  0
#define SENSOR_FAN          1
#define SENSOR_VOLTAGE      2


typedef struct
	{
	gint		major_version,
				minor_version,
				rev_version;
	gint		fd;
	gchar		*hostname;
	gboolean	served,
				alive,
				last_client;
	gboolean	feature_subdisk;
	gchar		buffer[2048];
	}
	GkrellmdClient;


typedef struct
	{
	gint	timer_ticks,
			second_tick,
			two_second_tick,
			five_second_tick,
			ten_second_tick,
			minute_tick;
	}
	GkrellmdTicks;

typedef struct
	{
	gchar		*name;
	void		(*update_monitor)(gboolean force);
	gchar		*(*serve_data)(GkrellmdClient *);
	void		(*serve_setup)(GkrellmdClient *);
	}
	GkrellmdMonitor;

struct GkrellmdConfig
	{
	gint		update_HZ;
	gint		debug_level;
	gint		*server_fd;
	gint		max_clients;
	gint		server_port;
	gint		verbose;
	time_t		start_time;
	gint		io_timeout;
	gint		reconnect_timeout;

	gint		fs_interval,
				nfs_interval,
				inet_interval;

	gchar		*pidfile;
	};



extern struct GkrellmdConfig	_GK;
extern GkrellmdTicks			GK;

extern GList	*gkrellmd_client_list;

void			gkrellmd_client_read(gint client_fd, gint nbytes);

GkrellmdMonitor *gkrellmd_init_mail_monitor(void);
void			gkrellmd_load_monitors(void);
gint			gkrellmd_update_monitors(void);
void			gkrellmd_serve_setup(GkrellmdClient *client);
gint			gkrellmd_send_to_client(GkrellmdClient *client, gchar *buf);
void			gkrellmd_free_glist_and_data(GList **);
void			gkrellmd_add_mailbox(gchar *);
void			gkrellmd_add_serveflag_done(gboolean *);
