/* GKrellM
|  Copyright (C) 1999-2002 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.  Version 2 is in the
|  COPYRIGHT file in the top level directory of this distribution.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gkrellm.h"
#include "gkrellm-private.h"
#include "gkrellm-sysdeps.h"

#if defined(__linux__)
#include "sysdeps/linux.c"
#endif

#if defined(__APPLE__)
#include "sysdeps/darwin.c"
#include "sysdeps/bsd-common.c"
#endif

#if defined(__FreeBSD__)
#include "sysdeps/freebsd.c"
#include "sysdeps/bsd-common.c"
#endif

#if defined(__NetBSD__)
#include "sysdeps/netbsd.c"
#include "sysdeps/bsd-net-open.c"
#include "sysdeps/bsd-common.c"
#endif

#if defined(__OpenBSD__)
#include "sysdeps/openbsd.c"
#include "sysdeps/bsd-net-open.c"
#include "sysdeps/bsd-common.c"
#endif

#if defined(__solaris__)
#include "sysdeps/solaris.c"
#endif

#if defined(USE_LIBGTOP)
#include "sysdeps/gtop.c"
#endif

#include <sys/utsname.h>

gchar *
gkrellm_sys_get_host_name(void)
	{
	static gboolean	have_it;
	static gchar	buf[128];

	if (!have_it && gethostname(buf, sizeof(buf)))
		strcpy(buf, "unknown");
	have_it = TRUE;
	return buf;
	}

gchar *
gkrellm_sys_get_system_name(void)
	{
	static gchar	*sname;
	struct utsname	utsn;

	if (!sname && !uname(&utsn))
		sname = g_strdup_printf("%s %s", utsn.sysname, utsn.release);
	return sname;
	}

