/* GKrellM
|  Copyright (C) 1999-2003 Bill Wilson
|
|  Author:  Bill Wilson    bill@gkrellm.net
|  Latest versions might be found at:  http://gkrellm.net
|
|  This program is free software which I release under the GNU General Public
|  License. You may redistribute and/or modify this program under the terms
|  of that license as published by the Free Software Foundation; either
|  version 2 of the License, or (at your option) any later version.
|
|  This program is distributed in the hope that it will be useful,
|  but WITHOUT ANY WARRANTY; without even the implied warranty of
|  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
|  GNU General Public License for more details.  Version 2 is in the
|  COPYRIGHT file in the top level directory of this distribution.
| 
|  To get a copy of the GNU General Puplic License, write to the Free Software
|  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* Interface to some gdk deprecated functions.  There are other gdk_font
|  deprecated functions still in main.c and gdk_text_extents() in winops-x11.c
|  and winops-win32.c.
|  Replacing these will be on hold until I know if there will be pango
|  replacements for them in Gtk/Gdk 2.2.  When this is done, code elsewhere
|  using g_locale_from_utf8() and the below gkrellm_locale_dup_string()
|  should be checked/modified.
*/

#include "gkrellm.h"
#include "gkrellm-private.h"

gint
gkrellm_gdk_string_width(GdkFont *font, gchar *string)
	{
	return gdk_string_measure(font, string);
	}

void
gkrellm_gdk_draw_string(GdkDrawable *drawable, GdkFont *font, GdkGC *gc,
			gint x, gint y, gchar *string)
	{
	gdk_draw_string(drawable, font, gc, x, y, string);
	}

void
gkrellm_gdk_draw_text(GdkDrawable *drawable, GdkFont *font, GdkGC *gc,
			gint x, gint y, gchar *string, gint len)
	{
	gdk_draw_text(drawable, font, gc, x, y, string, len);
	}

  /* Gtk config widgets work with utf8, so as long as I'm using gdk_draw
  |  functions, both utf8 and current locale versions of strings drawn on
  |  GKrellM must be maintained.  If src is not utf8, *dst is converted
  |  to utf8 and this should fix 1.2 -> 2.0 user_config conversions
  |  (This function will usually be called from config loading).
  |  dst_locale is piggy backing so when gdk_draw is replaced by Pango
  |  equivalents, usage of this function can be replaced with a simple
  |  gkrellm_dup_string().
  */
gboolean
gkrellm_locale_dup_string(gchar **dst_utf8, gchar *src, gchar **dst_locale)
	{
	if (!dst_utf8 || (!*dst_utf8 && !src))
		return FALSE;
	if (*dst_utf8)
		{
		if (src && !strcmp(*dst_utf8, src))
			return FALSE;
		g_free(*dst_utf8);
		g_free(*dst_locale);
		}
	if (src)
		{
		if (g_utf8_validate(src, -1, NULL))
			{
			*dst_utf8 = g_strdup(src);
			*dst_locale = g_locale_from_utf8(src, -1, NULL, NULL, NULL);
			}
		else
			{
			*dst_utf8 = g_locale_to_utf8(src, -1, NULL, NULL, NULL);
			*dst_locale = g_strdup(src);
			}
		}
	else
		{
		*dst_utf8 = NULL;
		*dst_locale = NULL;
		}
	return TRUE;
	}

