/* GnomeICU
 * Copyright (C) 1998-2002 Jeremy Wise
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Functions for facilitating authorization (GUI)
 * first created by Patrick Sung (Jan 2002)
 */

#include "common.h"

#include "gnomeicu.h"
#include "auth.h"
#include "gtkfunc.h"
#include "util.h"
#include "v7snac13.h"

#include <gtk/gtk.h>

static UIN_T req_uin = NULL;

void auth_sendbutton_clicked (GtkWidget *w, gpointer d);
void auth_cancelbutton_clicked (GtkWidget *w, gpointer d);
gboolean auth_receive_dialog (gchar *msg);
void auth_grantbutton_clicked (GtkWidget *w, gpointer d);
void auth_denybutton_clicked (GtkWidget *w, gpointer d);

/* display an edit box asking for authorization request message */
void
auth_request_msg_box (const gchar *nick, UIN_T uin)
{
  GladeXML *authbox;
  GtkWidget *authlabel;
  GtkWidget *authmsg;
  GtkWidget *sendbutton;
  gchar *str, *message;

#ifdef TRACE_FUNCTION
  g_print( "auth_request_msg_box\n" );
#endif

  g_assert(uin != NULL);

  authbox = gicu_util_open_glade_xml ("auth.glade", "auth_request");
  if (authbox == NULL)
    return;

  authlabel = glade_xml_get_widget (authbox, "authlabel");
  message = g_strdup_printf (_("User %s (%s) need authorization. GnomeICU is going "
                               "to send an authorization message to your friend."),
                             nick ? nick : "", uin);

  str = g_strdup_printf ("<span weight=\"bold\" size=\"larger\">%s</span>\n\n%s",
                         _("Request Authorization"), message);
  gtk_label_set_markup (GTK_LABEL (authlabel), str);
  g_free (message);
  g_free (str);

  authmsg = glade_xml_get_widget (authbox, "authmsgtext");
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (authmsg), 
			       GTK_WRAP_WORD);
  str = g_strdup_printf (_("Please authorize my request and add me to your "
			   "Contact List. %s (%s)."),
			 our_info->nick, our_info->uin);
  gtk_text_buffer_set_text(GTK_TEXT_BUFFER(gtk_text_view_get_buffer(GTK_TEXT_VIEW(authmsg))), str, -1);
  g_free (str);

  g_object_set_data (G_OBJECT (glade_xml_get_widget (authbox, "cancelbutton")),
                     "dlg", glade_xml_get_widget (authbox, "auth_request"));
  g_object_set_data (G_OBJECT (glade_xml_get_widget (authbox, "sendbutton")),
                     "dlg", glade_xml_get_widget (authbox, "auth_request"));
  g_object_set_data (G_OBJECT (glade_xml_get_widget (authbox, "sendbutton")),
                     "text", authmsg);

  /* connect the signals for the send button and cancel button */
  glade_xml_signal_autoconnect (authbox);

  sendbutton = glade_xml_get_widget (authbox, "sendbutton");
  gtk_widget_grab_focus (sendbutton);


  g_object_unref (G_OBJECT (authbox));
}

/* auth request message box signal handler - send button */
void
auth_sendbutton_clicked (GtkWidget *w, gpointer d)
{
  GtkWidget *dialog;
  GtkWidget *text;
  GtkTextBuffer* text_buffer;
  GtkTextIter start_iter, end_iter;
  gchar *msg;

#ifdef TRACE_FUNCTION
  g_print( "auth_sendbutton_clicked\n" );
#endif

  dialog = g_object_get_data (G_OBJECT (w), "dlg");

  if (!is_connected(GTK_WINDOW(dialog), _("You can not ask authorization while being disconnected.")))
    return;

  text = g_object_get_data (G_OBJECT (w), "text");
  text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(text));
  gtk_text_buffer_get_bounds(text_buffer, &start_iter, &end_iter);  
  
  msg = gtk_text_buffer_get_text(text_buffer, &start_iter, &end_iter, FALSE);

  v7_ask_uin_for_auth (mainconnection, msg);

  g_free (msg);
  gtk_widget_destroy (dialog);
}

/* auth request message box signal handler - cancel button */
void
auth_cancelbutton_clicked (GtkWidget *w, gpointer d)
{
  GtkWidget *dialog;

#ifdef TRACE_FUNCTION
  g_print( "auth_cancelbutton_clicked\n" );
#endif

  dialog = g_object_get_data (G_OBJECT (w), "dlg");
  gtk_widget_destroy (dialog);
}

/* auth request received from other users, show the auth receive msg box */
void
auth_receive_request (UIN_T uin, const gchar *msg)
{
  gchar *mymsg;

  g_assert(uin != NULL);

  if (req_uin != NULL)
	  g_free (req_uin);
  req_uin = g_strdup (uin);
  mymsg = g_strdup (msg);

  /* do the auth stuff */
  g_idle_add ((GSourceFunc)auth_receive_dialog, mymsg);
}

gboolean
auth_receive_dialog (gchar *msg)
{
  GladeXML *authbox;
  GtkWidget *grantlabel;
  GtkWidget *reqmsg;
  GtkWidget *grantbutton;
  gchar *str, *message;
  GtkTextBuffer* text_buffer;

#ifdef TRACE_FUNCTION
  g_print( "auth_receive_dialog\n" );
#endif

  authbox = gicu_util_open_glade_xml ("auth.glade", "auth_recv");
  if (authbox == NULL)
    return FALSE;

  grantlabel = glade_xml_get_widget (authbox, "grantlabel");
  message = g_strdup_printf (_("User %s is requesting authorization. Do you want to "
                               "grant the authorization so he/she can add you?"),
                             req_uin);

  str = g_strdup_printf ("<span weight=\"bold\" size=\"larger\">%s</span>\n\n%s",
                         _("Received Authorization Request"), message);
  gtk_label_set_markup (GTK_LABEL (grantlabel), str);
  g_free (message);
  g_free (str);

  reqmsg = glade_xml_get_widget (authbox, "grantmsgtext");
  gtk_text_view_set_wrap_mode (GTK_TEXT_VIEW (reqmsg), 
			       GTK_WRAP_WORD);
  text_buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(reqmsg));
  gtk_text_buffer_set_text(text_buffer, msg, -1);

  g_object_set_data (G_OBJECT (glade_xml_get_widget (authbox, "denybutton")),
                     "dlg", glade_xml_get_widget (authbox, "auth_recv"));
  g_object_set_data (G_OBJECT (glade_xml_get_widget (authbox, "grantbutton")),
                     "dlg", glade_xml_get_widget (authbox, "auth_recv"));

  glade_xml_signal_autoconnect (authbox);

  grantbutton = glade_xml_get_widget (authbox, "grantbutton");
  gtk_widget_grab_focus (grantbutton);

  g_object_unref (G_OBJECT (authbox));

  /* make sure we free the allocated str malloc from auth_receive_request() */
  g_free (msg);

  return FALSE;

  /* Additional features: (TODO) */
  /*  - also get user info from server using the UIN? */
  /*  - provide button to add user as well? if user is not on your list already
   *    which should be doing something similar to add_from_search() in search.c
   */
}


void
auth_grantbutton_clicked (GtkWidget *w, gpointer d)
{
  GtkWidget *dialog;

  dialog = g_object_get_data (G_OBJECT (w), "dlg");

  if (!is_connected(GTK_WINDOW(dialog), _("You can not grant authorization while being disconnected.")))
    return;

  gtk_widget_destroy (dialog);

  v7_grant_auth_request (mainconnection, req_uin);
}

void
auth_denybutton_clicked (GtkWidget *w, gpointer d)
{
  GtkWidget *dialog;

  dialog = g_object_get_data (G_OBJECT (w), "dlg");

  if (!is_connected(GTK_WINDOW(dialog), _("You can not deny authorization while being disconnected.")))
    return;
  gtk_widget_destroy (dialog);
}
