/***************************************
 Blink stuff, handle other timed events
 (c) 1999 Jeremy Wise
 GnomeICU
****************************************/

#include "common.h"
#include "flash.h"
#include "gnomeicu.h"
#include "icons.h"
#include "gtkfunc.h"
#include "showlist.h"

#include <gtk/gtk.h>

/*** Global functions ***/
guint flash_messages( void )
{
	static gboolean flash = FALSE;
	static char prev_status = 0;
	int have_message = 0;

	GSList *contact;

	flash = !flash;

	if( (Current_Status & 0xffff) == STATUS_DND )
		flash = 1;

	for (contact = Contacts; contact; contact = contact->next )
	{
		if( g_slist_length( kontakt->stored_messages ) )
		{
			int type = ((STORED_MESSAGE_PTR)kontakt->stored_messages->data)->type;
			have_message = TRUE;
			if( flash )
				set_contact_icon (kontakt, get_pixbuf_for_message (type));
			else
				set_contact_icon (kontakt, icon_blank_pixbuf);
		}
	}

	if( have_message )
	{
		ready_set( flash );
	}

	if( have_message != prev_status )
	{
		prev_status = have_message;
		gtk_window_set_title (GTK_WINDOW (MainData->window),
		                      have_message ? _("GnomeICU: Msgs") : "GnomeICU");
		ready_set( have_message ? flash : FALSE );
	}

	return TRUE;
}
