/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001-2002 CodeFactory AB
 * Copyright (C) 2001-2002 Richard Hult <rhult@codefactory.se>
 * Copyright (C) 2001-2002 Mikael Hallendal <micke@codefactory.se>
 * Copyright (C) 2002      Anders Carlsson <andersca@gnu.org>

 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __MRP_STORAGE_MPX_H__
#define __MRP_STORAGE_MPX_H__

#include <glib-object.h>
#include "mrproject/mrp-storage-module.h"
#include "mrproject/mrp-types.h"
#include "mrproject/mrp-project.h"

extern GType mrp_storage_mpx_type;

#define MRP_TYPE_STORAGE_MPX		mrp_storage_mpx_type
#define MRP_STORAGE_MPX(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), MRP_TYPE_STORAGE_MPX, MrpStorageMpx))
#define MRP_STORAGE_MPX_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), MRP_TYPE_STORAGE_MPX, MrpStorageMpxClass))
#define MRP_IS_STORAGE_MPX(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), MRP_TYPE_STORAGE_MPX))
#define MRP_IS_STORAGE_MPX_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((obj), MRP_TYPE_STORAGE_MPX))
#define MRP_STORAGE_MPX_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), MRP_TYPE_STORAGE_MPX, MrpStorageMpxClass))

typedef struct _MrpStorageMpx      MrpStorageMpx;
typedef struct _MrpStorageMpxClass MrpStorageMpxClass;

struct _MrpStorageMpx
{
	MrpStorageModule  parent;

	MrpProject       *project;
	gchar            *name;
	gchar            *organization;
	gchar            *manager;

	MrpTask *root_task;
	mrptime project_start;
	
	GList      *resources;
	GList *assignments;
};

struct _MrpStorageMpxClass
{
	MrpStorageModuleClass parent_class;
};

void mrp_storage_mpx_register_type (GTypeModule *module);

#endif /* __MRP_STORAGE_MPX_H__ */
