/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is 
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Seth Spitzer <sspitzer@netscape.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or 
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "nsNewsDownloadDialogArgs.h"
#include "nsCRT.h"
#include "nsReadableUtils.h"

nsNewsDownloadDialogArgs::nsNewsDownloadDialogArgs()
{
    NS_INIT_ISUPPORTS();
    
    mGroupName = "";
    mArticleCount = 0;
    mServerKey = "";
    mHitOK = PR_FALSE;
    mDownloadAll = PR_FALSE;
}

nsNewsDownloadDialogArgs::~nsNewsDownloadDialogArgs()
{
}

NS_IMPL_ISUPPORTS1(nsNewsDownloadDialogArgs, nsINewsDownloadDialogArgs)

NS_IMETHODIMP nsNewsDownloadDialogArgs::GetGroupName(char * *aGroupName)
{
    NS_ENSURE_ARG_POINTER(aGroupName);

    *aGroupName = ToNewCString(mGroupName);

    return NS_OK;
}
NS_IMETHODIMP nsNewsDownloadDialogArgs::SetGroupName(const char * aGroupName)
{
    NS_ENSURE_ARG_POINTER(aGroupName);

    mGroupName = aGroupName;

    return NS_OK;
}
NS_IMETHODIMP nsNewsDownloadDialogArgs::GetArticleCount(PRInt32 *aArticleCount)
{
    NS_ENSURE_ARG_POINTER(aArticleCount);

    *aArticleCount = mArticleCount;

    return NS_OK;
}
NS_IMETHODIMP nsNewsDownloadDialogArgs::SetArticleCount(PRInt32 aArticleCount)
{
    mArticleCount = aArticleCount;

    return NS_OK;
}
NS_IMETHODIMP nsNewsDownloadDialogArgs::GetServerKey(char * *aServerKey)
{
    NS_ENSURE_ARG_POINTER(aServerKey);
    
    *aServerKey = ToNewCString(mServerKey);
    return NS_OK;
}
NS_IMETHODIMP nsNewsDownloadDialogArgs::SetServerKey(const char * aServerKey)
{
    NS_ENSURE_ARG_POINTER(aServerKey);

    mServerKey = aServerKey;

    return NS_OK;
}
NS_IMETHODIMP nsNewsDownloadDialogArgs::GetHitOK(PRBool *aHitOK)
{
    NS_ENSURE_ARG_POINTER(aHitOK);
    
    *aHitOK = mHitOK;

    return NS_OK;
}
NS_IMETHODIMP nsNewsDownloadDialogArgs::SetHitOK(PRBool aHitOK)
{
    mHitOK = aHitOK;

    return NS_OK;
}
NS_IMETHODIMP nsNewsDownloadDialogArgs::GetDownloadAll(PRBool *aDownloadAll)
{
    NS_ENSURE_ARG_POINTER(aDownloadAll);

    *aDownloadAll = mDownloadAll;

    return NS_OK;
}
NS_IMETHODIMP nsNewsDownloadDialogArgs::SetDownloadAll(PRBool aDownloadAll)
{
    mDownloadAll = aDownloadAll;

    return NS_OK;
}
