/*
 * The contents of this file are subject to the Mozilla Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 * 
 * The Original Code is the Netscape security libraries.
 * 
 * The Initial Developer of the Original Code is Netscape
 * Communications Corporation.  Portions created by Netscape are 
 * Copyright (C) 1994-2000 Netscape Communications Corporation.  All
 * Rights Reserved.
 * 
 * Contributor(s):
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL"), in which case the provisions of the GPL are applicable 
 * instead of those above.  If you wish to allow use of your 
 * version of this file only under the terms of the GPL and not to
 * allow others to use your version of this file under the MPL,
 * indicate your decision by deleting the provisions above and
 * replace them with the notice and other provisions required by
 * the GPL.  If you do not delete the provisions above, a recipient
 * may use your version of this file under either the MPL or the
 * GPL.
 */

#ifndef __SEC_ERR_H_
#define __SEC_ERR_H_


#define SEC_ERROR_BASE				(-0x2000)
#define SEC_ERROR_LIMIT				(SEC_ERROR_BASE + 1000)

#define IS_SEC_ERROR(code) \
    (((code) >= SEC_ERROR_BASE) && ((code) < SEC_ERROR_LIMIT))

#ifndef NO_SECURITY_ERROR_ENUM
typedef enum {
SEC_ERROR_IO 				    =	SEC_ERROR_BASE + 0,
SEC_ERROR_LIBRARY_FAILURE 		    =	SEC_ERROR_BASE + 1,
SEC_ERROR_BAD_DATA 			    =	SEC_ERROR_BASE + 2,
SEC_ERROR_OUTPUT_LEN 			    =	SEC_ERROR_BASE + 3,
SEC_ERROR_INPUT_LEN 			    =	SEC_ERROR_BASE + 4,
SEC_ERROR_INVALID_ARGS 			    =	SEC_ERROR_BASE + 5,
SEC_ERROR_INVALID_ALGORITHM 		    =	SEC_ERROR_BASE + 6,
SEC_ERROR_INVALID_AVA 			    =	SEC_ERROR_BASE + 7,
SEC_ERROR_INVALID_TIME 			    =	SEC_ERROR_BASE + 8,
SEC_ERROR_BAD_DER 			    =	SEC_ERROR_BASE + 9,
SEC_ERROR_BAD_SIGNATURE 		    =	SEC_ERROR_BASE + 10,
SEC_ERROR_EXPIRED_CERTIFICATE 		    =	SEC_ERROR_BASE + 11,
SEC_ERROR_REVOKED_CERTIFICATE 		    =	SEC_ERROR_BASE + 12,
SEC_ERROR_UNKNOWN_ISSUER 		    =	SEC_ERROR_BASE + 13,
SEC_ERROR_BAD_KEY 			    =	SEC_ERROR_BASE + 14,
SEC_ERROR_BAD_PASSWORD 			    =	SEC_ERROR_BASE + 15,
SEC_ERROR_RETRY_PASSWORD 		    =	SEC_ERROR_BASE + 16,
SEC_ERROR_NO_NODELOCK 			    =	SEC_ERROR_BASE + 17,
SEC_ERROR_BAD_DATABASE 			    =	SEC_ERROR_BASE + 18,
SEC_ERROR_NO_MEMORY 			    =	SEC_ERROR_BASE + 19,
SEC_ERROR_UNTRUSTED_ISSUER 		    =	SEC_ERROR_BASE + 20,
SEC_ERROR_UNTRUSTED_CERT 		    =	SEC_ERROR_BASE + 21,
SEC_ERROR_DUPLICATE_CERT 		    =	(SEC_ERROR_BASE + 22),
SEC_ERROR_DUPLICATE_CERT_NAME 		    =	(SEC_ERROR_BASE + 23),
SEC_ERROR_ADDING_CERT 			    =	(SEC_ERROR_BASE + 24),
SEC_ERROR_FILING_KEY 			    =	(SEC_ERROR_BASE + 25),
SEC_ERROR_NO_KEY 			    =	(SEC_ERROR_BASE + 26),
SEC_ERROR_CERT_VALID 			    =	(SEC_ERROR_BASE + 27),
SEC_ERROR_CERT_NOT_VALID 		    =	(SEC_ERROR_BASE + 28),
SEC_ERROR_CERT_NO_RESPONSE 		    =	(SEC_ERROR_BASE + 29),
SEC_ERROR_EXPIRED_ISSUER_CERTIFICATE 	    =	(SEC_ERROR_BASE + 30),
SEC_ERROR_CRL_EXPIRED 			    =	(SEC_ERROR_BASE + 31),
SEC_ERROR_CRL_BAD_SIGNATURE 		    =	(SEC_ERROR_BASE + 32),
SEC_ERROR_CRL_INVALID 			    =	(SEC_ERROR_BASE + 33),
SEC_ERROR_EXTENSION_VALUE_INVALID 	    = 	(SEC_ERROR_BASE + 34),
SEC_ERROR_EXTENSION_NOT_FOUND 		    = 	(SEC_ERROR_BASE + 35),
SEC_ERROR_CA_CERT_INVALID 		    = 	(SEC_ERROR_BASE + 36),
SEC_ERROR_PATH_LEN_CONSTRAINT_INVALID 	    = 	(SEC_ERROR_BASE + 37),
SEC_ERROR_CERT_USAGES_INVALID 		    = 	(SEC_ERROR_BASE + 38),
SEC_INTERNAL_ONLY 			    =	(SEC_ERROR_BASE + 39),
SEC_ERROR_INVALID_KEY 			    =	(SEC_ERROR_BASE + 40),
SEC_ERROR_UNKNOWN_CRITICAL_EXTENSION 	    = 	(SEC_ERROR_BASE + 41),
SEC_ERROR_OLD_CRL 			    =	(SEC_ERROR_BASE + 42),
SEC_ERROR_NO_EMAIL_CERT 		    =	(SEC_ERROR_BASE + 43),
SEC_ERROR_NO_RECIPIENT_CERTS_QUERY 	    =	(SEC_ERROR_BASE + 44),
SEC_ERROR_NOT_A_RECIPIENT 		    =	(SEC_ERROR_BASE + 45),
SEC_ERROR_PKCS7_KEYALG_MISMATCH 	    =	(SEC_ERROR_BASE + 46),
SEC_ERROR_PKCS7_BAD_SIGNATURE 		    =	(SEC_ERROR_BASE + 47),
SEC_ERROR_UNSUPPORTED_KEYALG 		    =	(SEC_ERROR_BASE + 48),
SEC_ERROR_DECRYPTION_DISALLOWED 	    =	(SEC_ERROR_BASE + 49),
/* Fortezza Alerts */
XP_SEC_FORTEZZA_BAD_CARD 		    =	(SEC_ERROR_BASE + 50),
XP_SEC_FORTEZZA_NO_CARD 		    =	(SEC_ERROR_BASE + 51),
XP_SEC_FORTEZZA_NONE_SELECTED 		    =	(SEC_ERROR_BASE + 52),
XP_SEC_FORTEZZA_MORE_INFO 		    =	(SEC_ERROR_BASE + 53),
XP_SEC_FORTEZZA_PERSON_NOT_FOUND 	    =	(SEC_ERROR_BASE + 54),
XP_SEC_FORTEZZA_NO_MORE_INFO 		    =	(SEC_ERROR_BASE + 55),
XP_SEC_FORTEZZA_BAD_PIN 		    =	(SEC_ERROR_BASE + 56),
XP_SEC_FORTEZZA_PERSON_ERROR 		    =	(SEC_ERROR_BASE + 57),
SEC_ERROR_NO_KRL 			    =	(SEC_ERROR_BASE + 58),
SEC_ERROR_KRL_EXPIRED 			    =	(SEC_ERROR_BASE + 59),
SEC_ERROR_KRL_BAD_SIGNATURE 		    =	(SEC_ERROR_BASE + 60),
SEC_ERROR_REVOKED_KEY 			    =	(SEC_ERROR_BASE + 61),
SEC_ERROR_KRL_INVALID 			    =	(SEC_ERROR_BASE + 62),
SEC_ERROR_NEED_RANDOM 			    =	(SEC_ERROR_BASE + 63),
SEC_ERROR_NO_MODULE 			    =	(SEC_ERROR_BASE + 64),
SEC_ERROR_NO_TOKEN 			    =	(SEC_ERROR_BASE + 65),
SEC_ERROR_READ_ONLY 			    =	(SEC_ERROR_BASE + 66),
SEC_ERROR_NO_SLOT_SELECTED 		    =	(SEC_ERROR_BASE + 67),
SEC_ERROR_CERT_NICKNAME_COLLISION 	    =	(SEC_ERROR_BASE + 68),
SEC_ERROR_KEY_NICKNAME_COLLISION 	    =	(SEC_ERROR_BASE + 69),
SEC_ERROR_SAFE_NOT_CREATED 		    =	(SEC_ERROR_BASE + 70),
SEC_ERROR_BAGGAGE_NOT_CREATED 		    =	(SEC_ERROR_BASE + 71),
XP_JAVA_REMOVE_PRINCIPAL_ERROR 		    =	(SEC_ERROR_BASE + 72),
XP_JAVA_DELETE_PRIVILEGE_ERROR 		    =	(SEC_ERROR_BASE + 73),
XP_JAVA_CERT_NOT_EXISTS_ERROR 		    =	(SEC_ERROR_BASE + 74),
SEC_ERROR_BAD_EXPORT_ALGORITHM 		    =	(SEC_ERROR_BASE + 75),
SEC_ERROR_EXPORTING_CERTIFICATES 	    =	(SEC_ERROR_BASE + 76),
SEC_ERROR_IMPORTING_CERTIFICATES 	    =	(SEC_ERROR_BASE + 77),
SEC_ERROR_PKCS12_DECODING_PFX 		    =	(SEC_ERROR_BASE + 78),
SEC_ERROR_PKCS12_INVALID_MAC 		    =	(SEC_ERROR_BASE + 79),
SEC_ERROR_PKCS12_UNSUPPORTED_MAC_ALGORITHM  =	(SEC_ERROR_BASE + 80),
SEC_ERROR_PKCS12_UNSUPPORTED_TRANSPORT_MODE =	(SEC_ERROR_BASE + 81),
SEC_ERROR_PKCS12_CORRUPT_PFX_STRUCTURE 	    =	(SEC_ERROR_BASE + 82),
SEC_ERROR_PKCS12_UNSUPPORTED_PBE_ALGORITHM  = 	(SEC_ERROR_BASE + 83),
SEC_ERROR_PKCS12_UNSUPPORTED_VERSION 	    =	(SEC_ERROR_BASE + 84),
SEC_ERROR_PKCS12_PRIVACY_PASSWORD_INCORRECT =	(SEC_ERROR_BASE + 85),
SEC_ERROR_PKCS12_CERT_COLLISION 	    =	(SEC_ERROR_BASE + 86),
SEC_ERROR_USER_CANCELLED 		    =	(SEC_ERROR_BASE + 87),
SEC_ERROR_PKCS12_DUPLICATE_DATA 	    =	(SEC_ERROR_BASE + 88),
SEC_ERROR_MESSAGE_SEND_ABORTED 		    =	(SEC_ERROR_BASE + 89),
SEC_ERROR_INADEQUATE_KEY_USAGE 		    =	(SEC_ERROR_BASE + 90),
SEC_ERROR_INADEQUATE_CERT_TYPE 		    =	(SEC_ERROR_BASE + 91),
SEC_ERROR_CERT_ADDR_MISMATCH 		    =	(SEC_ERROR_BASE + 92),
SEC_ERROR_PKCS12_UNABLE_TO_IMPORT_KEY 	    =	(SEC_ERROR_BASE + 93),
SEC_ERROR_PKCS12_IMPORTING_CERT_CHAIN 	    =	(SEC_ERROR_BASE + 94),
SEC_ERROR_PKCS12_UNABLE_TO_LOCATE_OBJECT_BY_NAME = (SEC_ERROR_BASE + 95),
SEC_ERROR_PKCS12_UNABLE_TO_EXPORT_KEY 	    =	(SEC_ERROR_BASE + 96),
SEC_ERROR_PKCS12_UNABLE_TO_WRITE 	    = 	(SEC_ERROR_BASE + 97),
SEC_ERROR_PKCS12_UNABLE_TO_READ 	    =	(SEC_ERROR_BASE + 98),
SEC_ERROR_PKCS12_KEY_DATABASE_NOT_INITIALIZED 	 = (SEC_ERROR_BASE + 99),
SEC_ERROR_KEYGEN_FAIL 			    =	(SEC_ERROR_BASE + 100),
SEC_ERROR_INVALID_PASSWORD 		    =	(SEC_ERROR_BASE + 101),
SEC_ERROR_RETRY_OLD_PASSWORD 		    =	(SEC_ERROR_BASE + 102),
SEC_ERROR_BAD_NICKNAME 			    =	(SEC_ERROR_BASE + 103),
SEC_ERROR_NOT_FORTEZZA_ISSUER 		    = 	(SEC_ERROR_BASE + 104),
SEC_ERROR_CANNOT_MOVE_SENSITIVE_KEY         =   (SEC_ERROR_BASE + 105),
SEC_ERROR_JS_INVALID_MODULE_NAME 	    =	(SEC_ERROR_BASE + 106),
SEC_ERROR_JS_INVALID_DLL 		    =	(SEC_ERROR_BASE + 107),
SEC_ERROR_JS_ADD_MOD_FAILURE 		    =	(SEC_ERROR_BASE + 108),
SEC_ERROR_JS_DEL_MOD_FAILURE 		    =	(SEC_ERROR_BASE + 109),
SEC_ERROR_OLD_KRL 			    =	(SEC_ERROR_BASE + 110),
SEC_ERROR_CKL_CONFLICT 			    =	(SEC_ERROR_BASE + 111),
SEC_ERROR_CERT_NOT_IN_NAME_SPACE 	    =	(SEC_ERROR_BASE + 112),
SEC_ERROR_KRL_NOT_YET_VALID 		    =	(SEC_ERROR_BASE + 113),
SEC_ERROR_CRL_NOT_YET_VALID 		    =	(SEC_ERROR_BASE + 114),
SEC_ERROR_UNKNOWN_CERT 			    =	(SEC_ERROR_BASE + 115),
SEC_ERROR_UNKNOWN_SIGNER 		    =	(SEC_ERROR_BASE + 116),
SEC_ERROR_CERT_BAD_ACCESS_LOCATION 	    =	(SEC_ERROR_BASE + 117),
SEC_ERROR_OCSP_UNKNOWN_RESPONSE_TYPE 	    =	(SEC_ERROR_BASE + 118),
SEC_ERROR_OCSP_BAD_HTTP_RESPONSE 	    =	(SEC_ERROR_BASE + 119),
SEC_ERROR_OCSP_MALFORMED_REQUEST 	    =	(SEC_ERROR_BASE + 120),
SEC_ERROR_OCSP_SERVER_ERROR 		    =	(SEC_ERROR_BASE + 121),
SEC_ERROR_OCSP_TRY_SERVER_LATER 	    =	(SEC_ERROR_BASE + 122),
SEC_ERROR_OCSP_REQUEST_NEEDS_SIG 	    =	(SEC_ERROR_BASE + 123),
SEC_ERROR_OCSP_UNAUTHORIZED_REQUEST 	    =	(SEC_ERROR_BASE + 124),
SEC_ERROR_OCSP_UNKNOWN_RESPONSE_STATUS 	    =	(SEC_ERROR_BASE + 125),
SEC_ERROR_OCSP_UNKNOWN_CERT 		    =	(SEC_ERROR_BASE + 126),
SEC_ERROR_OCSP_NOT_ENABLED 		    =	(SEC_ERROR_BASE + 127),
SEC_ERROR_OCSP_NO_DEFAULT_RESPONDER 	    =	(SEC_ERROR_BASE + 128),
SEC_ERROR_OCSP_MALFORMED_RESPONSE 	    =	(SEC_ERROR_BASE + 129),
SEC_ERROR_OCSP_UNAUTHORIZED_RESPONSE 	    =	(SEC_ERROR_BASE + 130),
SEC_ERROR_OCSP_FUTURE_RESPONSE 		    =	(SEC_ERROR_BASE + 131),
SEC_ERROR_OCSP_OLD_RESPONSE 		    =	(SEC_ERROR_BASE + 132),
/* smime stuff */
SEC_ERROR_DIGEST_NOT_FOUND		    =	(SEC_ERROR_BASE + 133),
SEC_ERROR_UNSUPPORTED_MESSAGE_TYPE	    =	(SEC_ERROR_BASE + 134),
SEC_ERROR_MODULE_STUCK			    =	(SEC_ERROR_BASE + 135),
SEC_ERROR_BAD_TEMPLATE			    =	(SEC_ERROR_BASE + 136)

} SECErrorCodes;
#endif /* NO_SECURITY_ERROR_ENUM */

#endif /* __SEC_ERR_H_ */
