// -*- mode: c  -*-
// Copyright (C) 2002 mediaWays GmbH Internet-Services, Verl, Germany
//
// PURPOSE OF THIS FILE: Define the non-opaque part to the LDAP-C-API
//
// - Automatic Version Information via RCS:
//   $Id: ldapapi.h,v 1.1 2002/09/23 07:28:51 robertj Exp $
//   $Source: /home/cvsroot/openh323/include/ldapapi.h,v $

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is the OpenLDAP Comatible LDAP-API for OpenH323
 * (libldapapi).
 *
 * The Initial Developer of the Original Code is
 * mediaWays GmbH Internet-Services, Verl, Germany
 * Portions created by the Initial Developer are Copyright (C) 2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Nils Bokermann <Nils.Bokermann@mediaWays.net> (*)
 *                 Martin Frhlich <Martin.Froehlich@mediaWays.net> (*)
 *
 * (*) Contributors marked this way are mediaWays employees, all their work
 *     is subject to mediaWays copyright by their contracts.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * For copies of the GPL or LGPL, see either http://www.fsf.org/licenses/
 * or write to the Free Software Foundation, Inc., 59 Temple Place - Suite
 * 330, Boston, MA 02111-1307, USA.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef LDAP_OPENH323_H
#define LDAP_OPENH323_H "@(#) $Id: ldapapi.h,v 1.1 2002/09/23 07:28:51 robertj Exp $"


// LDAP-C-API C defines

#if defined(__cplusplus) || defined(c_plusplus)
#	define LDAP_BEGIN_DECL	extern "C" {
#	define LDAP_END_DECL	}
#else
#	define LDAP_BEGIN_DECL	/* begin declarations */
#	define LDAP_END_DECL	/* end declarations */
#endif

#if !defined(LDAP_NO_PROTOTYPES) && ( defined(LDAP_NEEDS_PROTOTYPES) || \
	defined(__STDC__) || defined(__cplusplus) || defined(c_plusplus) )

	/* ANSI C or C++ */
#	define LDAP_P(protos)	protos
#	define LDAP_CONCAT1(x,y)	x ## y
#	define LDAP_CONCAT(x,y)	LDAP_CONCAT1(x,y)
#	define LDAP_STRING(x)	#x /* stringify without expanding x */
#	define LDAP_XSTRING(x)	LDAP_STRING(x) /* expand x, then stringify */

#ifndef LDAP_CONST
#	define LDAP_CONST	const
#endif

#else /* no prototypes */

	/* traditional C */
#	define LDAP_P(protos)	()
#	define LDAP_CONCAT(x,y)	x/**/y
#	define LDAP_STRING(x)	"x"

#ifndef LDAP_CONST
#	define LDAP_CONST	/* no const */
#endif

#endif /* no prototypes */

#if (__GNUC__) * 1000 + (__GNUC_MINOR__) >= 2006
#	define LDAP_GCCATTR(attrs)	__attribute__(attrs)
#else
#	define LDAP_GCCATTR(attrs)
#endif


/* Support for NT dynamic libraries. */

/* LBER library */
#if defined(LBER_DECL) && defined(_WIN32)
#	define LBER_F(type)		extern __declspec(LBER_DECL) type
#	define LBER_V(type)		extern __declspec(LBER_DECL) type
#else
#	define LBER_F(type)		extern type
#	define LBER_V(type)		extern type
#endif

/* LDAP library */
#if defined(LDAP_DECL) && defined(_WIN32)
#	define LDAP_F(type)		extern __declspec(LDAP_DECL) type
#	define LDAP_V(type)		extern __declspec(LDAP_DECL) type
#else
#	define LDAP_F(type)		extern type
#	define LDAP_V(type)		extern type
#endif

/*
 * C library. Mingw32 links with the C run-time library by default,
 * so the explicit definition of CSTATIC will keep dllimport from
 * being defined.
 */
#if (defined(__MINGW32__) && !defined(CSTATIC) || \
     defined(_WIN32) && defined(_DLL))
#	define LDAP_LIBC_F(type)	extern __declspec(dllimport) type
#	define LDAP_LIBC_V(type)	extern __declspec(dllimport) type
#else
#	define LDAP_LIBC_F(type)	extern type
#	define LDAP_LIBC_V(type)	extern type
#endif

/* AVL library */
#if defined(LDAP_AVL_DECL) && defined(_WIN32)
#	define LDAP_AVL_F(type)	extern __declspec(LDAP_AVL_DECL) type
#	define LDAP_AVL_V(type)	extern __declspec(LDAP_AVL_DECL) type
#else
#	define LDAP_AVL_F(type)	extern type
#	define LDAP_AVL_V(type)	extern type
#endif

/* LDBM library */
#if defined(LDAP_LDBM_DECL) && defined(_WIN32)
#	define LDAP_LDBM_F(type)	extern __declspec(LDAP_LDBM_DECL) type
#	define LDAP_LDBM_V(type)	extern __declspec(LDAP_LDBM_DECL) type
#else
#	define LDAP_LDBM_F(type)	extern type
#	define LDAP_LDBM_V(type)	extern type
#endif

/* LDIF library */
#if defined(LDAP_LDIF_DECL) && defined(_WIN32)
#	define LDAP_LDIF_F(type)	extern __declspec(LDAP_LDIF_DECL) type
#	define LDAP_LDIF_V(type)	extern __declspec(LDAP_LDIF_DECL) type
#else
#	define LDAP_LDIF_F(type)	extern type
#	define LDAP_LDIF_V(type)	extern type
#endif

/* LUNICODE library */
#if defined(LDAP_LUNICODE_DECL) && defined(_WIN32)
#	define LDAP_LUNICODE_F(type)	extern __declspec(LDAP_LUNICODE_DECL) type
#	define LDAP_LUNICODE_V(type)	extern __declspec(LDAP_LUNICODE_DECL) type
#else
#	define LDAP_LUNICODE_F(type)	extern type
#	define LDAP_LUNICODE_V(type)	extern type
#endif

/* LUTIL library */
#if defined(LDAP_LUTIL_DECL) && defined(_WIN32)
#	define LDAP_LUTIL_F(type)	extern __declspec(LDAP_LUTIL_DECL) type
#	define LDAP_LUTIL_V(type)	extern __declspec(LDAP_LUTIL_DECL) type
#else
#	define LDAP_LUTIL_F(type)	extern type
#	define LDAP_LUTIL_V(type)	extern type
#endif

/* SLAPD (as a module exporting symbols) */
#if defined(LDAP_SLAPD_DECL) && defined(_WIN32)
#	define LDAP_SLAPD_F(type)	extern __declspec(LDAP_SLAPD_DECL) type
#	define LDAP_SLAPD_V(type)	extern __declspec(LDAP_SLAPD_DECL) type
#else
#	define LDAP_SLAPD_F(type)	extern type
#	define LDAP_SLAPD_V(type)	extern type
#endif



// Define the non-opaque part to the LDAP-C-API

typedef size_t ber_len_t;

typedef struct berval {
  ber_len_t bv_len;
  char *bv_val;
} BerValue;


typedef struct berelement {
  PINDEX number;
} BerElement;


LDAP_F(void) ber_bvfree LDAP_P((struct berval *bv));

LDAP_F(void) ber_bvecfree LDAP_P((struct berval **bv));

LDAP_F(struct berval *) ber_bvdup LDAP_P((struct berval *));

LDAP_F(void) ber_free LDAP_P((BerElement *ber, int fbuf));


/*
 * We'll use 2000+draft revision for our API version number
 * As such, the number will be above the old RFC but below 
 * whatever number does finally get assigned
 */

// The API version. Should be the RFC to which it conforms. This will be 200 + draftnumber
#define LDAP_API_VERSION        2005
#define LDAP_VENDOR_NAME        "OpenH.323-LDAP"

// Vendor Version 100 x version-number
#define LDAP_VENDOR_VERSION     001 /* version 0.01 */
#define LDAP_VERSION1   1
#define LDAP_VERSION2   2
#define LDAP_VERSION3   3

#define LDAP_VERSION_MIN        LDAP_VERSION2
#define LDAP_VERSION            LDAP_VERSION2
#define LDAP_VERSION_MAX        LDAP_VERSION   /* This SHOULD be version 3
						 but the ASN.1 File will 
						 describe only version 2 */
// search scopes 
#define LDAP_SCOPE_BASE		(0)
#define LDAP_SCOPE_ONELEVEL	(1)
#define LDAP_SCOPE_SUBTREE	(2)

// LDAP options
#define LDAP_OPT_API_INFO			0x0000
#define LDAP_OPT_DESC				0x0001 /* deprecated */
#define LDAP_OPT_DEREF				0x0002
#define LDAP_OPT_SIZELIMIT			0x0003
#define LDAP_OPT_TIMELIMIT			0x0004
/* 0x05 - 0x07 not defined by current draft */
#define LDAP_OPT_REFERRALS			0x0008
#define LDAP_OPT_RESTART			0x0009
/* 0x0a - 0x10 not defined by current draft */
#define LDAP_OPT_PROTOCOL_VERSION	        0x0011
#define LDAP_OPT_SERVER_CONTROLS	        0x0012
#define LDAP_OPT_CLIENT_CONTROLS  	        0x0013
/* 0x14 not defined by current draft */
#define LDAP_OPT_API_FEATURE_INFO	        0x0015

/* 0x16 - 0x2f not defined by current draft */
#define LDAP_OPT_HOST_NAME			0x0030
#define	LDAP_OPT_ERROR_NUMBER		        0x0031
#define LDAP_OPT_ERROR_STRING		        0x0032
#define LDAP_OPT_MATCHED_DN			0x0033

/* 0x34 - 0x0fff not defined by current draft */

#define LDAP_OPT_PRIVATE_EXTENSION_BASE 0x4000  /* to 0x7FFF inclusive */

/* private and experimental options */
/* OpenLDAP specific options */
#define LDAP_OPT_DEBUG_LEVEL		0x5001	/* debug level */
#define LDAP_OPT_TIMEOUT		0x5002	/* default timeout */
#define LDAP_OPT_REFHOPLIMIT		0x5003	/* ref hop limit */
#define LDAP_OPT_NETWORK_TIMEOUT        0x5005  /* socket level timeout */
#define LDAP_OPT_URI			0x5006

/* OpenLDAP TLS options */
// Defined, but not used
#define LDAP_OPT_X_TLS			0x6000
#define LDAP_OPT_X_TLS_CTX		0x6001	/* SSL CTX */
#define LDAP_OPT_X_TLS_CACERTFILE	0x6002
#define LDAP_OPT_X_TLS_CACERTDIR	0x6003
#define LDAP_OPT_X_TLS_CERTFILE		0x6004
#define LDAP_OPT_X_TLS_KEYFILE		0x6005
#define LDAP_OPT_X_TLS_REQUIRE_CERT	0x6006
/* #define LDAP_OPT_X_TLS_PROTOCOL		0x6007 */
#define LDAP_OPT_X_TLS_CIPHER_SUITE	0x6008
#define LDAP_OPT_X_TLS_RANDOM_FILE	0x6009

#define LDAP_OPT_X_TLS_NEVER		0
#define LDAP_OPT_X_TLS_HARD		1
#define LDAP_OPT_X_TLS_DEMAND		2
#define LDAP_OPT_X_TLS_ALLOW		3
#define LDAP_OPT_X_TLS_TRY		4

/* OpenLDAP SASL options */
// Not used. Only simple bind					 
#define LDAP_OPT_X_SASL_MECH			0x6100
#define LDAP_OPT_X_SASL_REALM			0x6101
#define LDAP_OPT_X_SASL_AUTHCID			0x6102
#define LDAP_OPT_X_SASL_AUTHZID			0x6103
#define LDAP_OPT_X_SASL_SSF			0x6104 /* read-only */
#define LDAP_OPT_X_SASL_SSF_EXTERNAL	        0x6105 /* write-only */
#define LDAP_OPT_X_SASL_SECPROPS		0x6106 /* write-only */
#define LDAP_OPT_X_SASL_SSF_MIN			0x6107
#define LDAP_OPT_X_SASL_SSF_MAX			0x6108
#define	LDAP_OPT_X_SASL_MAXBUFSIZE		0x6109


						 /* on/off values */
						 // Switching on/off options
#define LDAP_OPT_ON	((void *) 1)
#define LDAP_OPT_OFF	((void *) 0)

/*
 * ldap_get_option() and ldap_set_option() return values.
 * As later versions may return other values indicating
 * failure, current applications should only compare returned
 * value against LDAP_OPT_SUCCESS.
 */
#define LDAP_OPT_SUCCESS	0
#define	LDAP_OPT_ERROR		(-1)

#define LDAP_API_INFO_VERSION   (1)
// structure to the API info. 
typedef struct ldapapiinfo {
  int    ldapai_info_version;            /** version of LDAPAPIInfo (1)  */
  int    ldapai_api_version;             /** revision of API supported */
  int    ldapai_protocol_version;        /** highest LDAP version supported */
  char **ldapai_extensions;              /** names of API extensions */
  char  *ldapai_vendor_name;             /** name of supplier */
  int    ldapai_vendor_version;          /** supplier-specific version * 100 */
} LDAPAPIInfo;

#define LDAP_FEATURE_INFO_VERSION (1)    /** version of api feature structure */
// api features
typedef struct ldap_apifeature_info {
  int    ldapaif_info_version;           /** version of this struct (1) */
  char  *ldapaif_name;                   /** matches LDAP_API_FEATURE_... less the prefix */
  int    ldapaif_version;                /** matches the value LDAP_API_FEATURE_... */
} LDAPAPIFeatureInfo;


typedef struct ldapcontrol {
  char         *ldctl_oid;
  struct berval	ldctl_value;
  char	        ldctl_iscritical;
} LDAPControl;

typedef struct ldapmod {
  int		mod_op;
  char		*mod_type;
  union mod_vals_u {
    char		**modv_strvals;
    struct berval	**modv_bvals;
  } mod_vals;
#define mod_values	mod_vals.modv_strvals
#define mod_bvalues	mod_vals.modv_bvals
} LDAPMod;


typedef struct ldap LDAP;
typedef struct ldapmsg LDAPMessage;


/* authentication methods available */
#define LDAP_AUTH_NONE		(0)	/** no authentication		  */
#define LDAP_AUTH_SIMPLE	(1)	/** context specific + primitive   */
#define LDAP_AUTH_SASL		(3)	/** context specific + constructed */

#define LDAP_SASL_SIMPLE		((char*)0)
#define LDAP_SASL_NULL			("")

#define LDAP_RES_ANY			(-1)

/* how many messages to retrieve results for */
#define LDAP_MSG_ONE		0x00
#define LDAP_MSG_ALL		0x01
#define LDAP_MSG_RECEIVED	0x02

#define LDAP_DEREF_NEVER	0x00
#define LDAP_DEREF_SEARCHING	0x01
#define LDAP_DEREF_FINDING	0x02
#define LDAP_DEREF_ALWAYS	0x03


/* possible result types a server can return */
#define LDAP_RES_BIND			(0x61U)	/* application + constructed */
#define LDAP_RES_SEARCH_ENTRY		(0x64U)	/* application + constructed */
#define LDAP_RES_SEARCH_REFERENCE	(0x73U)	/* V3: application + constructed */
#define LDAP_RES_SEARCH_RESULT		(0x65U)	/* application + constructed */
#define LDAP_RES_MODIFY			(0x67U)	/* application + constructed */
#define LDAP_RES_ADD			(0x69U)	/* application + constructed */
#define LDAP_RES_DELETE			(0x6bU)	/* application + constructed */
#define LDAP_RES_MODDN			(0x6dU)	/* application + constructed */
#define LDAP_RES_MODRDN			LDAP_RES_MODDN	/* application + constructed */
#define LDAP_RES_RENAME			LDAP_RES_MODDN	/* application + constructed */
#define LDAP_RES_COMPARE		(0x6fU)	/* application + constructed */
#define LDAP_RES_EXTENDED		(0x78U)	/* V3: application + constructed */
#define LDAP_RES_EXTENDED_PARTIAL	(0x79U)	/* V3+: application + constructed */

#define LDAP_RES_UNSOLICITED	(0)

#define LDAP_NO_LIMIT		0

// Returncodes of the API functions
#define LDAP_SUCCESS                    0x00
#define LDAP_OPERATIONS_ERROR           0x01
#define LDAP_PROTOCOL_ERROR             0x02
#define LDAP_TIMELIMIT_EXCEEDED         0x03
#define LDAP_SIZELIMIT_EXCEEDED         0x04
#define LDAP_COMPARE_FALSE              0x05
#define LDAP_COMPARE_TRUE               0x06
#define LDAP_AUTH_METHOD_NOT_SUPPORTED  0x07
#define LDAP_STRONG_AUTH_NOT_SUPPORTED       LDAP_AUTH_METHOD_NOT_SUPPORTED
#define LDAP_STRONG_AUTH_REQUIRED       0x08
#define LDAP_PARTIAL_RESULTS            0x09    /* LDAPv2+ (not LDAPv3) */

#define LDAP_REFERRAL                   0x0a /* LDAPv3 */
#define LDAP_ADMINLIMIT_EXCEEDED        0x0b /* LDAPv3 */
#define LDAP_UNAVAILABLE_CRITICAL_EXTENSION     0x0c /* LDAPv3 */
#define LDAP_CONFIDENTIALITY_REQUIRED   0x0d /* LDAPv3 */
#define LDAP_SASL_BIND_IN_PROGRESS      0x0e /* LDAPv3 */       

#define LDAP_ATTR_ERROR(n)  LDAP_RANGE((n),0x10,0x15) /* 16-21 */

#define LDAP_NO_SUCH_ATTRIBUTE          0x10
#define LDAP_UNDEFINED_TYPE             0x11
#define LDAP_INAPPROPRIATE_MATCHING     0x12
#define LDAP_CONSTRAINT_VIOLATION	0x13
#define LDAP_TYPE_OR_VALUE_EXISTS	0x14
#define LDAP_INVALID_SYNTAX		0x15

#define LDAP_NAME_ERROR(n)  LDAP_RANGE((n),0x20,0x24) /* 32-34,36 */

#define LDAP_NO_SUCH_OBJECT		0x20
#define LDAP_ALIAS_PROBLEM		0x21
#define LDAP_INVALID_DN_SYNTAX		0x22
#define LDAP_IS_LEAF			0x23 /* not LDAPv3 */
#define LDAP_ALIAS_DEREF_PROBLEM	0x24

#define LDAP_SECURITY_ERROR(n) LDAP_RANGE((n),0x30,0x32) /* 48-50 */

#define LDAP_INAPPROPRIATE_AUTH		0x30
#define LDAP_INVALID_CREDENTIALS	0x31
#define LDAP_INSUFFICIENT_ACCESS	0x32

#define LDAP_SERVICE_ERROR(n)  LDAP_RANGE((n),0x33,0x36) /* 51-54 */

#define LDAP_BUSY			0x33
#define LDAP_UNAVAILABLE		0x34
#define LDAP_UNWILLING_TO_PERFORM	0x35
#define LDAP_LOOP_DETECT		0x36

#define LDAP_UPDATE_ERROR(n)	LDAP_RANGE((n),0x40,0x47) /* 64-69,71 */
  
#define LDAP_NAMING_VIOLATION		0x40
#define LDAP_OBJECT_CLASS_VIOLATION	0x41
#define LDAP_NOT_ALLOWED_ON_NONLEAF	0x42
#define LDAP_NOT_ALLOWED_ON_RDN		0x43
#define LDAP_ALREADY_EXISTS		0x44
#define LDAP_NO_OBJECT_CLASS_MODS	0x45
#define LDAP_RESULTS_TOO_LARGE		0x46 /* CLDAP */
#define LDAP_AFFECTS_MULTIPLE_DSAS	0x47 /* LDAPv3 */

#define LDAP_OTHER			0x50

#define LDAP_API_ERROR(n)		LDAP_RANGE((n),0x51,0x61) /* 81-97 */
#define LDAP_API_RESULT(n)		(((n) == LDAP_SUCCESS) || \
                                          LDAP_RANGE((n),0x51,0x61)) /* 0,81-97 */

#define LDAP_SERVER_DOWN		0x51
#define LDAP_LOCAL_ERROR		0x52
#define LDAP_ENCODING_ERROR		0x53
#define LDAP_DECODING_ERROR		0x54
#define LDAP_TIMEOUT			0x55
#define LDAP_AUTH_UNKNOWN		0x56
#define LDAP_FILTER_ERROR		0x57
#define LDAP_USER_CANCELLED		0x58
#define LDAP_PARAM_ERROR		0x59
#define LDAP_NO_MEMORY			0x5a

/* not technically reserved for APIs */
#define LDAP_CONNECT_ERROR		0x5b	/* draft-ietf-ldap-c-api-xx */
#define LDAP_NOT_SUPPORTED		0x5c	/* draft-ietf-ldap-c-api-xx */
#define LDAP_CONTROL_NOT_FOUND		0x5d	/* draft-ietf-ldap-c-api-xx */
#define LDAP_NO_RESULTS_RETURNED	0x5e	/* draft-ietf-ldap-c-api-xx */
#define LDAP_MORE_RESULTS_TO_RETURN	0x5f	/* draft-ietf-ldap-c-api-xx */
#define LDAP_CLIENT_LOOP		0x60	/* draft-ietf-ldap-c-api-xx */
#define LDAP_REFERRAL_LIMIT_EXCEEDED	0x61	/* draft-ietf-ldap-c-api-xx */

// Modify entries
#define LDAP_MOD_ADD		(0x00)
#define LDAP_MOD_DELETE		(0x01)
#define LDAP_MOD_REPLACE	(0x02)
#define LDAP_MOD_BVALUES	(0x80)



#define LDAP_PORT                       389


/* Now define the real API */
/** @name Binding to a LDAP server.
    @deprecated ldap_bind
 */
//@{ 
/* in bind.cxx: */

/** ldap_init initializes the LDAP * session handle. This {\em must} be passed to all
    subsequent calls to this API. ldap_init will not open a connection to the ldap server.
*/

LDAP *ldap_init (const char *hostname, int portno);


/* depricated */ /* bind.cxx */
/** ldap_open initializes the LDAP * session handle. As in @ref{ldap_init} it {\em must}
    be passed to all following calls. Unlike ldap_init ldap_open will open a connection to
    a ldap server.
    @see ldap_init, ldap_bind
*/
LDAP *ldap_open (const char *hostname, int portno);

/* binding */

/// Bind with sasl mechanism. Currently only simple bind is allowed 
int ldap_sasl_bind (LDAP *ld,  char const *dn, char const *mechanism,
		    struct berval const *cred, LDAPControl **serverctrls,
		    LDAPControl **clientctrls, int *msgidp);

/// Bind with sasl mechanism. Synchronous version.
int ldap_sasl_bind_s (LDAP *ld,  char *dn, char const *mechanism,
		      struct berval const *cred, LDAPControl **serverctrls,
		      LDAPControl **clientctrls, struct berval **servercredp);

/// Bind with simple pasword.
int ldap_simple_bind (LDAP *ld,  char const *dn, char const *passwd);

/// Bind with simple pasword. Synchronous version.
int ldap_simple_bind_s (LDAP *ld,  char const *dn, char const *passwd);

/* depricated */
/// Old bind. For backward compatibility
int ldap_bind (LDAP *ld,  char const *dn, char const *cred, int method);

/// Old bind. For backward compatibility. Synchronous version.
int ldap_bind_s (LDAP *ld,  char const *dn, char const *cred, int method);
/*
LDAP_F(int) ldap_kerberos_bind LDAP_P((LDAP *ld,  char const *dn));

LDAP_F(int) ldap_kerberos_bind_s LDAP_P((LDAP *ld,  char const *dn));
*/
/* unbinding */

/// Unbind Request. Send an unbind request and terminate the connection.
int ldap_unbind_ext (LDAP *ld, LDAPControl *serverctrls, LDAPControl *clientctrls);

/// Unbind Request. Send an unbind request and terminate the connection.
int ldap_unbind (LDAP *ld);

/// Unbind Request. Send an unbind request and terminate the connection.
int ldap_unbind_s (LDAP *ld);
//@}
/* options */
/** @name Option handling
 */
//@{ 

/** Get an option from a connection. The user has to provide the right datatype and cast
    it to void.
*/
int ldap_get_option (LDAP *ld, int option, void *outvalue);

/** Set an option in a connection. The user has to provide the right datatype and cast
    it to void.
*/
int ldap_set_option (LDAP *ld, int option,  void const *outvalue);

//@}
/* searching */
/** @name Searching entries.
 */
//@{ 
/** Comlete search request. 
    @param base the search base
    @param scope the search scope
    @param filter the search filter 
    @param attrs array of attributes to be fetched or NULL
    @param attrsonly 0 if values \em and attributes should be fetched, in any other
    case only attributes will be fetched.
    @param timeout Servertimeout
    @param msgidp pointer to the messageID
*/
int ldap_search_ext (LDAP *ld,  char const *base,
  int scope,  char const *filter, char **attrs, int attrsonly, 
  LDAPControl **serverctrls, LDAPControl **clientctrls,
  struct timeval *timeout, int sizelimit, int *msgidp);

/** Complete search request (synchronous). 
    @param res the search results
    @see ldap_search_ext for details.
 */
int ldap_search_ext_s (LDAP *ld,  char const *base, int scope,  char const *filter,
		       char **attrs, int attrsonly, LDAPControl **serverctrls,
		       LDAPControl **clientctrls, struct timeval *timeout,
		       int sizelimit, LDAPMessage **res);
/** Simple search request. 
    @param base the search base
    @param scope the search scope
    @param filter the search filter 
    @param attrs array of attributes to be fetched or NULL
    @param attrsonly 0 if values \em and attributes should be fetched, in any other
    case only attributes will be fetched.
    @return messageID
*/
int ldap_search (LDAP *ld,  char const *base, int scope, char const *filter, char **attrs,
		 int attrsonly);

/** Simple search request (synchronous). @see ldap_search for details.
    @param res the search results
    @return LDAP_SUCCESS if search was successful, a LDAP error otherwise.
*/
int ldap_search_s (LDAP *ld,  char const *base, int scope, char const *filter, char **attrs,
		   int attrsonly, LDAPMessage **res);

/** Simple search request with timeout.
    @param timeout overall timeout to get the messages
    @see ldap_search_s
*/
int ldap_search_st (LDAP *ld,  char const *base, int scope, char const *filter, char **attrs,
		    int attrsonly, struct timeval *timeout, LDAPMessage **res);

//@}
/* comparing between local values and entries */
/** @name Comparing entries and local values.
 */
//@{ 
/** Compare. 
    @param attr array of attributes to compare
    @param bvalue array of bervals (values to compare)
    @param msgidp pointer to the messageid
    @return LDAP_SUCCESS on success. Error othterwise
*/
int ldap_compare_ext (LDAP *ld,  char const *dn, char const *attr, 
		      struct berval const *bvalue, LDAPControl **serverctrls,
		      LDAPControl **clientctrls, int *msgidp);

/** Compare (synchronous).
    @see ldap_compare_ext for details.
    @return MessageID
*/
int ldap_compare_ext_s (LDAP *ld,  char const *dn, char const *attr,
			struct berval const *bvalue, LDAPControl **serverctrls,
			LDAPControl **clientctrls);

/** Compare. 
    @param attr array of attributes to compare
    @param bvalue array of values
    @return MessageID
*/
int ldap_compare (LDAP *ld,  char const *dn, char const *attr, char const *value);

/** Compare. 
 */
int ldap_compare_s (LDAP *ld,  char const *dn, char const *attr, char const *value);
//@}


/* Modifying entries */
/** @name Modifying Entries.
    @deprecated ldap_modify ldap_modify_s
 */
//@{ 
/** Complete modification Request.
    @param mods Array of modifications
    @param msgidp Pointer to the messageid
    @return LDAP_SUCCESS on success. Error othterwise
 */
int ldap_modify_ext (LDAP *ld,  char const *dn, LDAPMod **mods, LDAPControl **serverctrls,
  LDAPControl **clientctrls, int *msgidp);

/** Complete modification Request (synchronous).
    @see ldap_modify_ext for details
*/
int ldap_modify_ext_s (LDAP *ld, char const *dn, LDAPMod **mods,
  LDAPControl **serverctrls, LDAPControl **clientctrls );

/* deprecated */
/// Simple modification request.
int ldap_modify (LDAP *ld, char const *dn, LDAPMod **mods);

/// Simple modification request (synchronous).
int ldap_modify_s (LDAP *ld, char const *dn, LDAPMod **mods);

/* Modifying names of entries */
#if (LDAP_VERSION_MAX >= LDAP_VERSION3)
int ldap_rename (LDAP *ld,  char *dn, char *dn,
  char *newrdn, char *newSuperior, int deleteoldrdn,
  LDAPControl **sctrls, LDAPControl **cctrls, int *msgidp); /* LDAPv3 */

int ldap_rename_s (LDAP *ld,  char *dn, char *newrdn,
  char *newSuperior, int deleteoldrdn, LDAPControl **sctrls,
  LDAPControl **cctrls);
#endif

/* deprecated with LDAPv3 */
/** Modify the relative distinguished name of an entry.
    @param deleteoldrdn 0 if not to delete the old rdn.
    @return MessageID
 */
int ldap_modrdn2 (LDAP *ld, char const *dn, char const *newrdn, int deleteoldrdn);

/** Modify the relative distinguished name of an entry (synchronous).
    @see ldap_modrdn2 for details
    @return LDAP_SUCCESS on success. Error otherwise
*/
int ldap_modrdn2_s (LDAP *ld,  char const *dn, char const *newrdn, int deleteoldrdn);

/** Modify the relative distinguished name of an entry.
    The old RDN will be deleted.
    @see ldap_modrdn2
*/
int ldap_modrdn (LDAP *ld,  char const *dn, char const *newrdn);

/** Modify the relative distinguished name of an entry (synchronous).
    The old RDN will be deleted.
    @see ldap_modrdn2
    @return LDAP_SUCCESS on success. Error otherwise
*/
int ldap_modrdn_s (LDAP *ld, char const *dn, char const *newrdn);


/* Adding entries */
/** Add an entry.
    @param attrs Array of attribute/values to add. The (*attr)->mod_op is ignored. 
    Only the decision wether to take the berval or the char is done.
    @param msgidp pointer to the MessageID
    @return LDAP_SUCCESS on success. Error otherwise
*/
int ldap_add_ext (LDAP *ld, char const *dn, LDAPMod **attrs,
  LDAPControl **serverctrls, LDAPControl **clientctrls, int *msgidp);

/** Add an entry (synchronous).
    @see ldap_add_ext for details.
*/
int ldap_add_ext_s (LDAP *ld, char const *dn, LDAPMod **attrs,
  LDAPControl **serverctrls, LDAPControl **clientctrls);
/** Add an entry.
    @see ldap_add_ext for details.
 */
int ldap_add (LDAP *ld,  char const *dn, LDAPMod **attrs);

/** Add an entry (synchronous).
    @see ldap_add_ext for details.
 */
int ldap_add_s (LDAP *ld,  char const *dn, LDAPMod **attrs );

/* Deleting entries */

/** Delete an entry.
    @param msgidp pointer to the MessageID
    @return LDAP_SUCCESS on success. Error otherwise
*/
int ldap_delete_ext (LDAP *ld,  char const *dn, LDAPControl **serverctrls,
		     LDAPControl **clientctrls, int *msgidp);

/** Delete an entry (synchronous).
    @see ldap_delete_ext for details.
 */
int ldap_delete_ext_s (LDAP *ld,  char const *dn, LDAPControl **serverctrls,
		       LDAPControl **clientctrls);

/** Delete an entry.
    @see ldap_delete_ext for details.
 */
int ldap_delete (LDAP *ld,  char const *dn );

/** Delete an entry (synchronous).
    @see ldap_delete_ext for details.
 */
int ldap_delete_s (LDAP *ld,  char const *dn );

//@}
#if (LDAP_VERSION_MAX >= LDAP_VERSION3)
int ldap_extended_operation (LDAP *ld, char *reqoid,
  struct berval *reqdata, LDAPControl **serverctrls,
  LDAPControl **clientctrls, int *msgidp);

int ldap_extended_operation_s (LDAP *ld, char *reqoid,
  struct berval *reqdata, LDAPControl **serverctrls,
  LDAPControl **clientctrls, char **retoidp, struct berval **retdatap);

int ldap_parse_extended_result (LDAP *ld, LDAPMessage *res,
  char **retoidp, struct berval **retdatap, int freeit);

int ldap_parse_extended_partial (LDAP *ld, LDAPMessage *res,
  char **retoidp, struct berval **retdatap, LDAPControl ***serverctrls,
  int freeit );
#endif /* LDAPv3 */

/* Abandoning operations */
/** @name Abandoning requests.
 */
//@{ 
/// Abandon.
int ldap_abandon_ext (LDAP *ld, int msgid, LDAPControl **serverctrls,
  LDAPControl **clientctrls);
/// Abandon.
int ldap_abandon (LDAP *ld, int msgid);

//@}
/* Obtaining results */
/** @name Getting resulsts.
    @deprecated ldap_result2error, ldap_perror
 */
//@{ 
/** Getting a LDAPMessage pointer.
    @param msgid MessageID.
    @param all 0 if not all messages should be fetched.
    @param timeout overall timeout for the operation.
    @param result pointer to LDAPMessage *
    @return type of the message fetched.    
*/
int ldap_result (LDAP *ld, int msgid, int all,struct timeval *timeout,
  LDAPMessage **result);

/// Getting the MessageID from an LDAPMessage
int ldap_msgid (LDAPMessage *lm);

/// Getting the message type from an LDAPMessage
int ldap_msgtype (LDAPMessage *lm);

/* Handling results */
/** Parse a LDAPMessage.
    @param matcheddnp the matched DN
    @param errmsg textual message the server returned.
    @param freeit 0 if the LDAPMessage should not be freed. 
*/
int ldap_parse_result (LDAP *ld, LDAPMessage *res, 
  int *errcodep, char **matcheddnp, char **errmsgp,
  char ***referralsp, LDAPControl ***serverctrls,
  int freeit);

int ldap_parse_sasl_bind_result (LDAP *ld, LDAPMessage *res,
  struct berval **servercredp, int freeit);

/// Get the textual representation of a numeric error.
const char * ldap_err2string (int err);

/* deprecated */
/// Get the error from a LDAPMessage.
int ldap_result2error (LDAP *ld, LDAPMessage *res, int freeit);

/* deprecated */
/// Print the textual error with a "string" in front.
void ldap_perror (LDAP *ld,  char const *s);

/* Stepping through results */
/// Get the first message of a chain.
LDAPMessage * ldap_first_message (LDAP *ld, LDAPMessage *chain);

/// Get the following message of a chain.
LDAPMessage * ldap_next_message (LDAP *ld, LDAPMessage *msg);

/// Count messages in chain.
int ldap_count_messages (LDAP *ld, LDAPMessage *chain);

/* Stepping through lists of entries or references */

/// Get first (LDAP) entry of chain.
LDAPMessage * ldap_first_entry (LDAP *ld, LDAPMessage *chain);

/// Get next (LDAP) entry of chain.
LDAPMessage * ldap_next_entry (LDAP *ld, LDAPMessage *entry);

/// Count (LDAP) entries of chain.
int ldap_count_entries (LDAP *ld, LDAPMessage *chain);
  
#if (LDAP_VERSION_MAX >= LDAP_VERSION3)
LDAPMessage * ldap_first_reference (LDAP *ld, LDAPMessage *chain);

LDAPMessage * ldap_next_reference (LDAP *ld, LDAPMessage *ref);

int ldap_count_references (LDAP *ld, LDAPMessage *chain);
#endif

/* Stepping through the attributes */
/// Get the first attribute from a LDAPMessage.
char * ldap_first_attribute (LDAP *ld, LDAPMessage *entry, BerElement **ber);

/// Get the next attribute from a LDAPMessage.
char * ldap_next_attribute (LDAP *ld, LDAPMessage *entry, BerElement *ber);

/* Retrieving the values of an attribute */

/// Get all values for an attribute from a LDAPMessage (as strings).
char ** ldap_get_values (LDAP *ld, LDAPMessage *entry, char const *target);

/// Get all values for an attribute from a LDAPMessage (as bervals).
struct berval ** ldap_get_values_len (LDAP *ld, LDAPMessage *entry,
				      char const *target);

/// Count values returned by ldap_get_values
int ldap_count_values (char **vals);

/// Count values returned by ldap_get_values_len
int ldap_count_values_len (struct berval **vals);

/* Retrieving the name of an entry */
/// get the DN of a LDAPMessage as a string.
char * ldap_get_dn (LDAP *ld, LDAPMessage *entry);

/// Get the user friendly notation of a DN.
char * ldap_dn2ufn ( char *dn);

/// Get all entries from a DN.
char ** ldap_explode_dn (char const *dn, int notypes);

/// Get all entries from a RDN.
char ** ldap_explode_rdn (char const *rdn, int notypes);


/* Retrieving the controls of an entry */ 
#if (LDAP_VERSION_MAX >= LDAP_VERSION3)

int ldap_get_entry_controls (LDAP *ld, LDAPMessage *entry,
  LDAPControl	***serverctrls);

#endif

/* Parsing references */
#if (LDAP_VERSION_MAX >= LDAP_VERSION3)

int ldap_parse_reference (LDAP *ld, LDAPMessage *ref,
  char ***referralsp, LDAPControl ***serverctrls, int freeit);

#endif

//@}

/* freeing memory */
/** @name Freeing memory returned by the ldap API
 */
//@{ 

#if (LDAP_VERSION_MAX >= LDAP_VERSION3)

void ldap_control_free (LDAPControl *ctrl);

void ldap_controls_free (LDAPControl **ctrl);

#endif

/// Frees the structure LDAPMessage.
int ldap_msgfree (LDAPMessage *lm);

/// Frees the char ** returned by ldap_get_values.
void ldap_value_free (char **vals);

/// Frees the struct berval ** returned by ldap_get_values_len.
void ldap_value_free_len (struct berval **vals);

/// Frees any char * returned by ldap-API functions
void ldap_memfree (char *mem);

//@}

#endif /* LDAP_OPENH323_H */
//
// End of ldapapi.h
//
