/*
 * h501pdu.h
 *
 * H.501 protocol handler
 *
 * Open H323 Library
 *
 * Copyright (c) 2003 Equivalence Pty. Ltd.
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Open H323 Library.
 *
 * The Initial Developer of the Original Code is Equivalence Pty. Ltd.
 *
 * Contributor(s): ______________________________________.
 *
 * $Log: h501pdu.h,v $
 * Revision 1.3  2003/03/01 00:23:42  craigs
 * New PeerElement implementation
 *
 * Revision 1.2  2003/02/25 06:48:15  robertj
 * More work on PDU transaction abstraction.
 *
 * Revision 1.1  2003/02/21 05:28:39  craigs
 * Factored out code for user with peer elements
 *
 */

#ifndef __OPAL_H501PDU_H
#define __OPAL_H501PDU_H

#ifdef P_USE_PRAGMA
#pragma interface
#endif


#include <ptlib/sockets.h>

#include "transports.h"
#include "h323trans.h"
#include "h501.h"

class H323_AnnexG;

/**Wrapper class for the H501 Annex G channel.
 */
class H501PDU : public H501_Message, public H323TransactionPDU
{
  PCLASSINFO(H501PDU, H501_Message);

  public:
    H501PDU();

    H501_ServiceRequest               & BuildServiceRequest              (unsigned seqnum, const H323TransportAddress & reply);
    H501_ServiceConfirmation          & BuildServiceConfirmation         (unsigned seqnum);
    H501_ServiceRejection             & BuildServiceRejection            (unsigned seqnum);
    H501_ServiceRelease               & BuildServiceRelease              (unsigned seqnum);
    H501_DescriptorRequest            & BuildDescriptorRequest           (unsigned seqnum, const H323TransportAddress & reply);
    H501_DescriptorConfirmation       & BuildDescriptorConfirmation      (unsigned seqnum);
    H501_DescriptorRejection          & BuildDescriptorRejection         (unsigned seqnum);
    H501_DescriptorIDRequest          & BuildDescriptorIDRequest         (unsigned seqnum, const H323TransportAddress & reply);
    H501_DescriptorIDConfirmation     & BuildDescriptorIDConfirmation    (unsigned seqnum);
    H501_DescriptorIDRejection        & BuildDescriptorIDRejection       (unsigned seqnum);
    H501_DescriptorUpdate             & BuildDescriptorUpdate            (unsigned seqnum, const H323TransportAddress & reply);
    H501_DescriptorUpdateAck          & BuildDescriptorUpdateACK         (unsigned seqnum);
    H501_AccessRequest                & BuildAccessRequest               (unsigned seqnum, const H323TransportAddress & reply);
    H501_AccessConfirmation           & BuildAccessConfirmation          (unsigned seqnum);
    H501_AccessRejection              & BuildAccessRejection             (unsigned seqnum);
    H501_RequestInProgress            & BuildRequestInProgress           (unsigned seqnum);
    H501_NonStandardRequest           & BuildNonStandardRequest          (unsigned seqnum, const H323TransportAddress & reply);
    H501_NonStandardConfirmation      & BuildNonStandardConfirmation     (unsigned seqnum);
    H501_NonStandardRejection         & BuildNonStandardRejection        (unsigned seqnum);
    H501_UnknownMessageResponse       & BuildUnknownMessageResponse      (unsigned seqnum);
    H501_UsageRequest                 & BuildUsageRequest                (unsigned seqnum, const H323TransportAddress & reply);
    H501_UsageConfirmation            & BuildUsageConfirmation           (unsigned seqnum);
    H501_UsageIndicationConfirmation  & BuildUsageIndicationConfirmation (unsigned seqnum);
    H501_UsageIndicationRejection     & BuildUsageIndicationRejection    (unsigned seqnum);
    H501_UsageRejection               & BuildUsageRejection              (unsigned seqnum);
    H501_ValidationRequest            & BuildValidationRequest           (unsigned seqnum, const H323TransportAddress & reply);
    H501_ValidationConfirmation       & BuildValidationConfirmation      (unsigned seqnum);
    H501_ValidationRejection          & BuildValidationRejection         (unsigned seqnum);
    H501_AuthenticationRequest        & BuildAuthenticationRequest       (unsigned seqnum, const H323TransportAddress & reply);
    H501_AuthenticationConfirmation   & BuildAuthenticationConfirmation  (unsigned seqnum);
    H501_AuthenticationRejection      & BuildAuthenticationRejection     (unsigned seqnum);

    void BuildRequest(unsigned tag, unsigned seqnum, const H323TransportAddress & replyAddr);
    void BuildPDU(unsigned tag, unsigned seqnum);

    // overrides from H323TransactionPDU
    const char * GetProtocolName()          { return "H501"; }
    BOOL Decode(PPER_Stream & strm)         { return H501_Message::Decode(strm); }
    void Encode(PPER_Stream & strm)         { H501_Message::Encode(strm); }
    void PrintOn(ostream & strm) const      { H501_Message::PrintOn(strm); }
    void SetTag(unsigned tag)               { m_body.SetTag(tag); }
    const PASN_Object & GetPDU() const      { return *this; }
    const PASN_Choice & GetChoice() const   { return m_body; }
    PASN_Object & GetPDU()                  { return *this; }
    PASN_Choice & GetChoice()               { return m_body; }
    unsigned GetSequenceNumber() const;

    // new functions
    unsigned GetTag() const                 { return m_body.GetTag(); }

    virtual BOOL Write(H323Transport & transport);
    virtual BOOL Write(H323Transport & transport, const H323TransportAddress & addr);
};

#endif  // __OPAL_H501PDU_H
