// -*- mode: c++  -*-
// Copyright (C) 2002 mediaWays GmbH Internet-Services, Verl, Germany
//
// PURPOSE OF THIS FILE: Implement the ldap_compare functions
//
// - Automatic Version Information via RCS:
//   $Id: ldapcompare.cxx,v 1.1 2002/09/23 07:28:52 robertj Exp $
//   $Source: /home/cvsroot/openh323/src/ldapcompare.cxx,v $

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is the OpenLDAP Comatible LDAP-API for OpenH323
 * (libldapapi).
 *
 * The Initial Developer of the Original Code is
 * mediaWays GmbH Internet-Services, Verl, Germany
 * Portions created by the Initial Developer are Copyright (C) 2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Nils Bokermann <Nils.Bokermann@mediaWays.net> (*)
 *                 Martin Frhlich <Martin.Froehlich@mediaWays.net> (*)
 *
 * (*) Contributors marked this way are mediaWays employees, all their work
 *     is subject to mediaWays copyright by their contracts.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * For copies of the GPL or LGPL, see either http://www.fsf.org/licenses/
 * or write to the Free Software Foundation, Inc., 59 Temple Place - Suite
 * 330, Boston, MA 02111-1307, USA.
 *
 * ***** END LICENSE BLOCK ***** */

#include <ptlib.h>
#include <ldapapi.h>
#include "ldap-int.h"


#ifndef lint
// mark object with version info in such a way that it is retrievable by
// the std. version/revision control tools like RCS/CVS ident cmd.. At
// least the strings cmd will extract this info.
volatile static const char vcid[] = "@(#) $Id: ldapcompare.cxx,v 1.1 2002/09/23 07:28:52 robertj Exp $";
volatile static const char vcHid[] = LDAP_OPENH323_H;
#endif

int ldap_compare_ext (LDAP *ld, LDAP_CONST char *dn, LDAP_CONST char *attr,
		      LDAP_CONST struct berval *bvalue, LDAPControl **serverctrls,
		      LDAPControl **clientctrls, int *msgidp) {
  if(NULL==ld)
    return LDAP_UNAVAILABLE;
  LDAP_LDAPMessage msg;
  *msgidp=++(ld->msg_id);
  msg.m_messageID=*msgidp;
  msg.m_protocolOp=LDAP_LDAPMessage_protocolOp(LDAP_LDAPMessage_protocolOp::e_compareDNRequest);

  LDAP_CompareRequest &cmp=msg.m_protocolOp;

  cmp.m_entry=dn;
  cmp.m_ava.m_attributeType=attr;
  cmp.m_ava.m_attributeValue.SetValue(PASN_OctetString(bvalue->bv_val,bvalue->bv_len));


  PBER_Stream encoding_stream;
  msg.Encode(encoding_stream);
  if(encoding_stream.Write(*(ld->socket))) {
    return LDAP_SUCCESS;
  }
  ld->ld_errno=LDAP_UNAVAILABLE;
  return ld->ld_errno;
}

int ldap_compare_ext_s (LDAP *ld, LDAP_CONST char *dn, LDAP_CONST char *attr,
			LDAP_CONST struct berval *bvalue, LDAPControl **serverctrls,
			LDAPControl **clientctrls) {
  int msgid,
    rv;
  LDAPMessage *result;

  rv=ldap_compare_ext(ld, dn, attr, bvalue, serverctrls, clientctrls, &msgid);
  if(LDAP_SUCCESS!=rv) {
    ld->ld_errno=rv;
    return rv;
  }
  if (-1== (rv=ldap_result( ld, msgid, 1, NULL, &result )) ) {
    return( ld->ld_errno );	/* ldap_result sets ld_errno */
  }
  return rv;
}



int ldap_compare (LDAP *ld, LDAP_CONST char *dn, LDAP_CONST char *attr,
		  LDAP_CONST char *value) {
  int msgid;
  int rv;

  struct berval bval;

  bval.bv_len=strlen(value);
  bval.bv_val=strndup(value,bval.bv_len);

  rv=ldap_compare_ext(ld, dn, attr, &bval, NULL, NULL, &msgid);

  if(LDAP_SUCCESS!=rv){
    ld->ld_errno=rv;
    return -1;
  }
  return msgid;
}


int ldap_compare_s (LDAP *ld, LDAP_CONST char *dn,  LDAP_CONST char *attr,
		    LDAP_CONST char *value) {
  int msgid,rv;
  LDAPMessage *result;
  if(-1==(msgid=ldap_compare(ld, dn, attr, value)))
    return ld->ld_errno;

  if (-1== (rv=ldap_result( ld, msgid, 1, NULL, &result )) ) {
    return( ld->ld_errno );	/* ldap_result sets ld_errno */
  }
  return rv;
}

//
// End of compare.cxx
//
