// -*- mode: c++  -*-
// Copyright (C) 2002 mediaWays GmbH Internet-Services, Verl, Germany
//
// PURPOSE OF THIS FILE: Implement memory-management functions.
//
// - Automatic Version Information via RCS:
//   $Id: ldapfree.cxx,v 1.2 2002/12/16 08:29:57 robertj Exp $
//   $Source: /home/cvsroot/openh323/src/ldapfree.cxx,v $

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is the OpenLDAP Comatible LDAP-API for OpenH323
 * (libldapapi).
 *
 * The Initial Developer of the Original Code is
 * mediaWays GmbH Internet-Services, Verl, Germany
 * Portions created by the Initial Developer are Copyright (C) 2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Nils Bokermann <Nils.Bokermann@mediaWays.net> (*)
 *                 Martin Frhlich <Martin.Froehlich@mediaWays.net> (*)
 *
 * (*) Contributors marked this way are mediaWays employees, all their work
 *     is subject to mediaWays copyright by their contracts.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * For copies of the GPL or LGPL, see either http://www.fsf.org/licenses/
 * or write to the Free Software Foundation, Inc., 59 Temple Place - Suite
 * 330, Boston, MA 02111-1307, USA.
 *
 * ***** END LICENSE BLOCK ***** */

#include <ptlib.h>
#include <ldapapi.h>
#include "ldap-int.h"
#include <vector.h>

#ifndef lint
// mark object with version info in such a way that it is retrievable by
// the std. version/revision control tools like RCS/CVS ident cmd.. At
// least the strings cmd will extract this info.
volatile static const char vcid[] = "@(#) $Id: ldapfree.cxx,v 1.2 2002/12/16 08:29:57 robertj Exp $";
volatile static const char vcHid[] = LDAP_OPENH323_H;
#endif

int ldap_free(LDAP *ld){
  if (NULL==ld) {
    delete ld->socket;
    delete ld->ld_options;
    delete ld;
  }
  ld=NULL;
  return 0;
}

int ldap_msgfree(LDAPMessage *msg){
  if(NULL==msg)
    return 0;
  LDAPMessage *tmp=msg->next;
  int type=0;
  while(tmp) {
    LDAPMessage *a=tmp;
    tmp=tmp->next;
    type=ldap_msgtype(a);
    delete a;
  }
  delete msg;
  msg=NULL;
  return type;
}

void ldap_memfree(char *mem){
  if(mem)
    //    free(mem);
    delete [] mem;
}

LDAP *ldap_new() {
  LDAP *ld=new struct ldap;
  if(NULL==ld)
    return NULL;
  ld->msg_id=0;
  ld->ld_version=LDAP_VERSION;
  ld->ld_options=new struct ldapoptions;
  struct ldapoptions *ldo=ld->ld_options;
  ldo->ldo_tm_api=NULL;
  ldo->ldo_tm_net=NULL;
  ldo->ldo_version=LDAP_VERSION2;
  ldo->ldo_deref=LDAP_DEREF_NEVER;
  ldo->ldo_timelimit=0;
  ldo->ldo_sizelimit=0;
  ldo->ldo_defbase=NULL;
  ldo->ldo_defbinddn=NULL;
  ldo->ldo_refhoplimit=0;
  ldo->ldo_valid=LDAP_VALID_SESSION;
  ld->ld_errno=LDAP_SUCCESS; // Let's stay optimistic :-)
  return ld;
}

char * strndup(const char s[],int n) {
  const char *old=s;
  size_t len=(size_t) n ; // Very optimistic...
  if(len < 8)
    len=8;
  char *nc=new char[len+1];
  //  char *nc=(char *) malloc(len+1);
  if(NULL==nc)
    return NULL;
  nc[n]='\0';
  memcpy(nc,old,n);
  return nc;
}

void ldap_value_free(char **vals){
  char **ptr=vals;
  while(*ptr!=NULL) {
    delete [] *ptr;
    ptr++;
  }
  delete []vals;
}

void ldap_value_free_len(struct berval **vals){
  struct berval **ptr=vals;
  while(*ptr!=NULL) {
    delete (*ptr)->bv_val; // Mem leak??
    ptr++;
  }
  delete []vals;
}


void ber_bvfree(struct berval *bv){
  if(bv) {
    if (bv->bv_val)
      delete bv->bv_val;
    delete bv;
  }
}

void ber_bvecfree (struct berval **bv){
  ldap_value_free_len(bv);
}


struct berval * ber_bvdup (struct berval *ber) {
  struct berval *bv=new struct berval;
  bv->bv_len=ber->bv_len;
  bv->bv_val=strndup(ber->bv_val,ber->bv_len);
  return bv;
}


void ber_free(BerElement *ber, int fbuf) {
  if(ber)
    delete ber;
}
//
// End of free.cxx
//
