// -*- mode: c++ -*-
// Copyright (C) 2002 mediaWays GmbH Internet-Services, Verl, Germany
//
// PURPOSE OF THIS FILE: initialisation...
//
// - Automatic Version Information via RCS:
//   $Id: ldapinit.cxx,v 1.2 2002/12/16 08:29:37 robertj Exp $
//   $Source: /home/cvsroot/openh323/src/ldapinit.cxx,v $

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is the OpenLDAP Comatible LDAP-API for OpenH323
 * (libldapapi).
 *
 * The Initial Developer of the Original Code is
 * mediaWays GmbH Internet-Services, Verl, Germany
 * Portions created by the Initial Developer are Copyright (C) 2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Nils Bokermann <Nils.Bokermann@mediaWays.net> (*)
 *                 Martin Frhlich <Martin.Froehlich@mediaWays.net> (*)
 *
 * (*) Contributors marked this way are mediaWays employees, all their work
 *     is subject to mediaWays copyright by their contracts.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * For copies of the GPL or LGPL, see either http://www.fsf.org/licenses/
 * or write to the Free Software Foundation, Inc., 59 Temple Place - Suite
 * 330, Boston, MA 02111-1307, USA.
 *
 * ***** END LICENSE BLOCK ***** */

#include <ptlib.h>
#include <ldapapi.h>
#include "ldap-int.h"

#ifndef lint
// mark object with version info in such a way that it is retrievable by
// the std. version/revision control tools like RCS/CVS ident cmd.. At
// least the strings cmd will extract this info.
volatile static const char vcid[] = "@(#) $Id: ldapinit.cxx,v 1.2 2002/12/16 08:29:37 robertj Exp $";
volatile static const char vcHid[] = LDAP_OPENH323_H;
#endif

/* directory separator */

#ifndef LDAP_DIRSEP
#ifndef _WIN32
#define LDAP_DIRSEP "/"
#else
#define LDAP_DIRSEP "\\"
#endif
#endif

#ifndef LDAP_SYSCONFDIR
#define LDAP_SYSCONFDIR		"/usr/local/etc/openldap"
#endif

#define LDAP_CONF_FILE	 LDAP_SYSCONFDIR LDAP_DIRSEP "ldap.conf"
#define LDAP_USERRC_FILE "ldaprc"
#define LDAP_ENV_PREFIX "LDAP"

struct ldapoptions ldap_int_global_options={LDAP_UNINITIALIZED};

struct ldapoptions *gopts;

#define ATTR_NONE	0
#define ATTR_BOOL	1
#define ATTR_INT	2
#define ATTR_KV		3
#define ATTR_STRING	4
#define ATTR_OPTION	5

#define ATTR_SASL	6
#define ATTR_TLS	7

static const struct ol_attribute {
  int	      useronly;
  int	      type;
  const char *name;
  const void *data;
  size_t      offset;
} attrs[] = {
  {0, ATTR_INT,		"SIZELIMIT",	NULL,
   offsetof(struct ldapoptions, ldo_sizelimit)},
  {0, ATTR_INT,		"TIMELIMIT",	NULL,
   offsetof(struct ldapoptions, ldo_timelimit)},
  {1, ATTR_STRING,	"BINDDN",		NULL,
   offsetof(struct ldapoptions, ldo_defbinddn)},
  {0, ATTR_STRING,	"BASE",			NULL,
   offsetof(struct ldapoptions, ldo_defbase)},
  {0, ATTR_INT,		"PORT",			NULL,		/* deprecated */
   offsetof(struct ldapoptions, ldo_defport)},
  {0, ATTR_OPTION,	"HOST",			NULL,	LDAP_OPT_HOST_NAME}, /* deprecated */
  {0, ATTR_OPTION,	"URI",			NULL,	LDAP_OPT_URI}, /* replaces HOST/PORT */
  {0, ATTR_NONE,		NULL,		NULL,	0}
};

void ldap_int_initialize_global_options( struct ldapoptions *gopts)
{
  gopts->ldo_version   = LDAP_VERSION2;
  gopts->ldo_deref     = LDAP_DEREF_NEVER;
  gopts->ldo_timelimit = LDAP_NO_LIMIT;
  gopts->ldo_sizelimit = LDAP_NO_LIMIT;

  gopts->ldo_tm_api = (struct timeval *)NULL;
  gopts->ldo_tm_net = (struct timeval *)NULL;

  /* ldo_defludp is leaked, we should have an at_exit() handler
   * to free this and whatever else needs to cleaned up. 
   */
  gopts->ldo_defport = LDAP_PORT;

  //  gopts->ldo_refhoplimit = LDAP_DEFAULT_REFHOPLIMIT;
  //  gopts->ldo_rebindproc = NULL;

  gopts->ldo_valid = LDAP_INITIALIZED;
  return;
}

static void ldap_init_w_conf (const char *file, int userconf) {
  char linebuf[128];
  FILE *fp;
  int i;
  char *cmd, *opt;
  char *start, *end;
  struct ldapoptions *gopts;
  
  if ((gopts = LDAP_INT_GLOBAL_OPT()) == NULL) {
    return; //Could not allocate mem for global options 
  }
  
  if (file == NULL) {
    // no file name 
    return;
  }
  
  fp = fopen(file, "r");
  if(fp == NULL) {
    // could not open file 
    return;
  }
  
  while((start = fgets(linebuf, sizeof(linebuf), fp)) != NULL) {
    /* skip lines starting with '#' */
    if(*start == '#') continue;
    
    /* trim leading white space */
    while((*start != '\0') && isspace((unsigned char) *start))
      start++;
    
    /* anything left? */
    if(*start == '\0') continue;
    
    /* trim trailing white space */
    end = &start[strlen(start)-1];
    while(isspace((unsigned char)*end)) end--;
    end[1] = '\0';
    
    /* anything left? */
    if(*start == '\0') continue;
    

    /* parse the command */
    cmd=start;
    while((*start != '\0') && !isspace((unsigned char)*start)) {
      start++;
    }
    if(*start == '\0') {
      /* command has no argument */
      continue;
    } 

    *start++ = '\0';

    /* we must have some whitespace to skip */
    while(isspace((unsigned char)*start)) start++;
    opt = start;
    
    for(i=0; attrs[i].type != ATTR_NONE; i++) {
      void *p;
      if( !userconf && attrs[i].useronly ) {
	continue;
      }
      
      if(strcasecmp(cmd, attrs[i].name) != 0) {
	continue;
      }

      switch(attrs[i].type) {
// 	case ATTR_BOOL:
// 	  if((strcasecmp(opt, "on") == 0) 
// 	     || (strcasecmp(opt, "yes") == 0)
// 	     || (strcasecmp(opt, "true") == 0))
// 	    {
// 	      LDAP_BOOL_SET(gopts, attrs[i].offset);
	      
// 	    } else {
// 	      LDAP_BOOL_CLR(gopts, attrs[i].offset);
// 	    }

// 	  break;
	  
	case ATTR_INT:
	  p = &((char *) gopts)[attrs[i].offset];
	  * (int*) p = atoi(opt);
	  break;
	  
	case ATTR_STRING:
	  p = &((char *) gopts)[attrs[i].offset];
	  if (* (char**) p != NULL) delete [] p;
	  * (char**) p = strndup(opt,strlen(opt));
	  break;
	case ATTR_OPTION:
	  ldap_set_option( NULL, attrs[i].offset, (void const *)opt );
	  break;
// 	case ATTR_SASL:
// #ifdef HAVE_CYRUS_SASL
// 	  ldap_int_sasl_config( gopts, attrs[i].offset, opt );
// #endif
// 	  break;
      }
    }
  }
  
  fclose(fp);
}

static void ldap_init_w_sysconf(const char *file) {
  ldap_init_w_conf( file, 0 );
}

static void ldap_init_w_userconf(const char *file) {
  char *home;
  char *path = NULL;
  
  if (file == NULL) {
    return;
  }

  home = getenv("HOME");
  
  if (home != NULL) {
    path = new char [strlen(home) + strlen(file) + 3];
  } 

  if(home != NULL && path != NULL) {
    // we assume UNIX path syntax is used... 
    
    // try ~/file 
    sprintf(path, "%s/%s", home, file);
    ldap_init_w_conf(path, 1);
    
    // try ~/.file 
    sprintf(path, "%s/.%s", home, file);
    ldap_init_w_conf(path, 1);
  }

  if(path != NULL) {
    delete [] path;
  }

  // try file 
  ldap_init_w_conf(file, 1);
}

    
void ldap_int_initialize(struct ldapoptions *lo) {
  if(NULL==gopts) {
    gopts=new (struct ldapoptions);
    if(NULL==gopts)
      return;
  }
    
  if ( gopts->ldo_valid == LDAP_INITIALIZED ) {
    return;
  }
  
  ldap_int_initialize_global_options(gopts);

  if( getenv("LDAPNOINIT") != NULL ) {
    return;
  }

    
  ldap_init_w_sysconf(LDAP_CONF_FILE);
  ldap_init_w_userconf(LDAP_USERRC_FILE);
  
  {
    char *altfile = getenv(LDAP_ENV_PREFIX "CONF");
    
    if( altfile != NULL ) {
      ldap_init_w_sysconf( altfile );
    }
  }
  
  {
    char *altfile = getenv(LDAP_ENV_PREFIX "RC");
    
    if( altfile != NULL ) {
      ldap_init_w_userconf( altfile );
    }
  }
}
//
// End of init.cxx
//
