/*
 * speexcodec.h
 *
 * Speex codec handler
 *
 * Open H323 Library
 *
 * Copyright (c) 2002 Equivalence Pty. Ltd.
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Open H323 Library.
 *
 * The Initial Developer of the Original Code is Equivalence Pty. Ltd.
 *
 * Contributor(s): ______________________________________.
 *
 * $Log: speexcodec.h,v $
 * Revision 1.8  2002/09/16 01:14:15  robertj
 * Added #define so can select if #pragma interface/implementation is used on
 *   platform basis (eg MacOS) rather than compiler, thanks Robert Monaghan.
 *
 * Revision 1.7  2002/08/22 08:30:23  craigs
 * Fixed remainder of Clone operators
 *
 * Revision 1.6  2002/08/20 15:22:50  rogerh
 * Make the codec name include the bitstream format for Speex to prevent users
 * with incompatible copies of Speex trying to use this codec.
 *
 * Revision 1.5  2002/08/15 18:35:36  rogerh
 * Fix more bugs with the Speex codec
 *
 * Revision 1.4  2002/08/14 19:34:31  rogerh
 * fix typo
 *
 * Revision 1.3  2002/08/14 04:26:20  craigs
 * Fixed ifdef problem
 *
 * Revision 1.2  2002/08/13 14:25:25  craigs
 * Added trailing newlines to avoid Linux warnings
 *
 * Revision 1.1  2002/08/13 14:14:28  craigs
 * Initial version
 *
 */

#ifndef __SPEEXCODEC_H
#define __SPEEXCODEC_H

#ifdef P_USE_PRAGMA
#pragma interface
#endif

#ifdef  SPEEX_CODEC

extern "C" {
#include "speex.h"
};

#include "h323caps.h"
#include "codecs.h"

#ifdef H323_STATIC_LIB
H323_STATIC_LOAD_REGISTER_CAPABILITY(SpeexNarrow2AudioCapability);
H323_STATIC_LOAD_REGISTER_CAPABILITY(SpeexNarrow3AudioCapability);
H323_STATIC_LOAD_REGISTER_CAPABILITY(SpeexNarrow4AudioCapability);
H323_STATIC_LOAD_REGISTER_CAPABILITY(SpeexNarrow5AudioCapability);
H323_STATIC_LOAD_REGISTER_CAPABILITY(SpeexNarrow6AudioCapability);
#endif

///////////////////////////////////////////////////////////////////////////////

class SpeexNonStandardAudioCapability : public H323NonStandardAudioCapability
{
  PCLASSINFO(SpeexNonStandardAudioCapability, H323NonStandardAudioCapability);

  public:
    SpeexNonStandardAudioCapability(const char * name);
    H323Codec * CreateCodec(int mode, H323Codec::Direction direction) const;
};

/////////////////////////////////////////////////////////////////////////

const PString SPEEX_NARROW2 = PString("Speex bs")
	+ PString(speex_nb_mode.bitstream_version) +PString(" Narrow2");
const PString SPEEX_NARROW3 = PString("Speex bs")
	+ PString(speex_nb_mode.bitstream_version) +PString(" Narrow3");
const PString SPEEX_NARROW4 = PString("Speex bs")
	+ PString(speex_nb_mode.bitstream_version) +PString(" Narrow4");
const PString SPEEX_NARROW5 = PString("Speex bs")
	+ PString(speex_nb_mode.bitstream_version) +PString(" Narrow5");
const PString SPEEX_NARROW6 = PString("Speex bs")
	+ PString(speex_nb_mode.bitstream_version) +PString(" Narrow6");

/////////////////////////////////////////////////////////////////////////

class SpeexNarrow2AudioCapability : public SpeexNonStandardAudioCapability
{
  PCLASSINFO(SpeexNarrow2AudioCapability, SpeexNonStandardAudioCapability);

  public:
    SpeexNarrow2AudioCapability()
      : SpeexNonStandardAudioCapability(SPEEX_NARROW2) 
      { }

    PObject * Clone() const
      { return new SpeexNarrow2AudioCapability(*this); }

    PString GetFormatName() const;

    H323Codec * CreateCodec(H323Codec::Direction direction) const
      { return SpeexNonStandardAudioCapability::CreateCodec(2, direction); } 
};

class SpeexNarrow3AudioCapability : public SpeexNonStandardAudioCapability
{
  PCLASSINFO(SpeexNarrow3AudioCapability, SpeexNonStandardAudioCapability);

  public:
    SpeexNarrow3AudioCapability()
      : SpeexNonStandardAudioCapability(SPEEX_NARROW3) 
      { }

    PObject * Clone() const
      { return new SpeexNarrow3AudioCapability(*this); }

    PString GetFormatName() const;

    H323Codec * CreateCodec(H323Codec::Direction direction) const
      { return SpeexNonStandardAudioCapability::CreateCodec(3, direction); } 
};

class SpeexNarrow4AudioCapability : public SpeexNonStandardAudioCapability
{
  PCLASSINFO(SpeexNarrow4AudioCapability, SpeexNonStandardAudioCapability);

  public:
    SpeexNarrow4AudioCapability()
      : SpeexNonStandardAudioCapability(SPEEX_NARROW4) 
      { }

    PObject * Clone() const
      { return new SpeexNarrow4AudioCapability(*this); }

    PString GetFormatName() const;

    H323Codec * CreateCodec(H323Codec::Direction direction) const
      { return SpeexNonStandardAudioCapability::CreateCodec(4, direction); } 
};

class SpeexNarrow5AudioCapability : public SpeexNonStandardAudioCapability
{
  PCLASSINFO(SpeexNarrow5AudioCapability, SpeexNonStandardAudioCapability);

  public:
    SpeexNarrow5AudioCapability()
      : SpeexNonStandardAudioCapability(SPEEX_NARROW5) 
      { }

    PObject * Clone() const
      { return new SpeexNarrow5AudioCapability(*this); }

    PString GetFormatName() const;

    H323Codec * CreateCodec(H323Codec::Direction direction) const
      { return SpeexNonStandardAudioCapability::CreateCodec(5, direction); } 
};

class SpeexNarrow6AudioCapability : public SpeexNonStandardAudioCapability
{
  PCLASSINFO(SpeexNarrow6AudioCapability, SpeexNonStandardAudioCapability);

  public:
    SpeexNarrow6AudioCapability()
      : SpeexNonStandardAudioCapability(SPEEX_NARROW6) 
      { }

    PObject * Clone() const
      { return new SpeexNarrow6AudioCapability(*this); }

    PString GetFormatName() const;

    H323Codec * CreateCodec(H323Codec::Direction direction) const
      { return SpeexNonStandardAudioCapability::CreateCodec(6, direction); } 
};

/////////////////////////////////////////////////////////////////////////

class SpeexCodec : public H323FramedAudioCodec
{
  PCLASSINFO(SpeexCodec, H323FramedAudioCodec);
  public:

  /**@name Construction */
  //@{
    /**Create a new Speex codec.
     */
    SpeexCodec(
      int mode,            /// Quality parameter passed to compressor
      Direction direction  /// Direction in which this instance runs
    );

    ~SpeexCodec();
  //@}

    /**Encode a sample block into the buffer specified.
       The samples have been read and are waiting in the readBuffer member
       variable. it is expected this function will encode exactly
       encodedBlockSize bytes.
     */
    virtual BOOL EncodeFrame(
      BYTE * buffer,    /// Buffer into which encoded bytes are placed
      unsigned & length /// Actual length of encoded data buffer
    );

    /**Decode a sample block from the buffer specified.
       The samples must be placed into the writeBuffer member variable. It is
       expected that no more than frameSamples is decoded. The return value
       is the number of samples decoded. Zero indicates an error.
     */
    virtual BOOL DecodeFrame(
      const BYTE * buffer,  /// Buffer from which encoded data is found
      unsigned length,      /// Length of encoded data buffer
      unsigned & written    /// Number of bytes used from data buffer
    );

  protected:
    SpeexBits bits;
    void * coder_state;
    unsigned encoder_frame_size;
};


/////////////////////////////////////////////////////////////////////////

#endif

#endif

