// -*- mode: c  -*-
// Copyright (C) 2002 mediaWays GmbH Internet-Services, Verl, Germany
//
// PURPOSE OF THIS FILE: Define the opaque part to the LDAP-C-API
//
// - Automatic Version Information via RCS:
//   $Id: ldap-int.h,v 1.1 2002/09/23 07:28:52 robertj Exp $
//   $Source: /home/cvsroot/openh323/src/ldap-int.h,v $

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is the OpenLDAP Comatible LDAP-API for OpenH323
 * (libldapapi).
 *
 * The Initial Developer of the Original Code is
 * mediaWays GmbH Internet-Services, Verl, Germany
 * Portions created by the Initial Developer are Copyright (C) 2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Nils Bokermann <Nils.Bokermann@mediaWays.net> (*)
 *                 Martin Frhlich <Martin.Froehlich@mediaWays.net> (*)
 *
 * (*) Contributors marked this way are mediaWays employees, all their work
 *     is subject to mediaWays copyright by their contracts.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * For copies of the GPL or LGPL, see either http://www.fsf.org/licenses/
 * or write to the Free Software Foundation, Inc., 59 Temple Place - Suite
 * 330, Boston, MA 02111-1307, USA.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef LDAP_INT_H
#define LDAP_INT_H "@(#) $Id: ldap-int.h,v 1.1 2002/09/23 07:28:52 robertj Exp $"

#include <ptlib/sockets.h>
#include <ptclib/asner.h>
#include <vector>

#include <ldap_asn.h>

typedef struct ldaphostenty {
  PString hostname;
  int port;
} LDAP_Hostentry;

struct ldapoptions {
  short ldo_valid;
#define LDAP_UNINITIALIZED	0x0
#define LDAP_INITIALIZED	0x1
#define LDAP_VALID_SESSION	0x2

  //  int		ldo_debug;
  /* per API call timeout */
  struct timeval		*ldo_tm_api;
  struct timeval		*ldo_tm_net;

  int	ldo_version;
  int	ldo_deref;
  int	ldo_timelimit;
  int	ldo_sizelimit;

  vector<LDAP_Hostentry*>  ldo_hostlist;

  int	ldo_defport;
  char*	ldo_defbase;
  char*	ldo_defbinddn;	/* bind dn */


  int	ldo_refhoplimit;	/* limit on referral nesting */
  /* LDAPv3 server and client controls */
  LDAPControl **ldo_sctrls;
  LDAPControl **ldo_cctrls;

  //  LDAP_BOOLEANS ldo_booleans;	/* boolean options */
};

typedef struct ldapmsg {
  ldapmsg          *next;
  LDAP_LDAPMessage *message;
} LDAPMessage;

struct ldap {
#define hostlist   ld_options->ldo_hostlist
/*   PASN_Stream            *encoding_stream; */
  PSocket                *socket;
  int                     msg_id;
  int                     ld_version;
  int                     std_port;
  struct ldapoptions      *ld_options;
  PString                 ld_error;
  int                     ld_errno;
  PString                 ld_matched;
  vector<LDAPMessage *>   ld_messages;
};

#define LDAP_INT_GLOBAL_OPT() (&ldap_int_global_options)

LDAP_F(int) ldap_free LDAP_P((struct ldap *ld));

LDAP_F(struct ldap *) ldap_new LDAP_P(());

LDAP_F(void) ldap_int_initialize_global_options LDAP_P(( struct ldapoptions *gopts));

LDAP_F(void) ldap_int_initialize LDAP_P((struct ldapoptions *lo));

char * strndup(const char *, int);

#endif /* LDAP_INT_H */
//
// End of ldap-int.h
//
