// -*- mode: c++  -*-
// Copyright (C) 2002 mediaWays GmbH Internet-Services, Verl, Germany
//
// PURPOSE OF THIS FILE: implenent the attribute/value functions
//
// - Automatic Version Information via RCS:
//   $Id: ldapgetattr.cxx,v 1.2 2002/10/11 12:19:00 rogerh Exp $
//   $Source: /home/cvsroot/openh323/src/ldapgetattr.cxx,v $

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is the OpenLDAP Comatible LDAP-API for OpenH323
 * (libldapapi).
 *
 * The Initial Developer of the Original Code is
 * mediaWays GmbH Internet-Services, Verl, Germany
 * Portions created by the Initial Developer are Copyright (C) 2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Nils Bokermann <Nils.Bokermann@mediaWays.net> (*)
 *                 Martin Frhlich <Martin.Froehlich@mediaWays.net> (*)
 *
 * (*) Contributors marked this way are mediaWays employees, all their work
 *     is subject to mediaWays copyright by their contracts.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * For copies of the GPL or LGPL, see either http://www.fsf.org/licenses/
 * or write to the Free Software Foundation, Inc., 59 Temple Place - Suite
 * 330, Boston, MA 02111-1307, USA.
 *
 * ***** END LICENSE BLOCK ***** */

#include <ptlib.h>
#include <ldapapi.h>
#include "ldap-int.h"

#ifndef lint
// mark object with version info in such a way that it is retrievable by
// the std. version/revision control tools like RCS/CVS ident cmd.. At
// least the strings cmd will extract this info.
volatile static const char vcid[] = "@(#) $Id: ldapgetattr.cxx,v 1.2 2002/10/11 12:19:00 rogerh Exp $";
volatile static const char vcHid[] = LDAP_OPENH323_H;
#endif

char * ldap_first_attribute (LDAP *ld, LDAPMessage *entry, BerElement **ber) {
  BerElement *number=new BerElement();
  number->number=0;
  *ber=number;
  return ldap_next_attribute(ld, entry, *ber);
}

char * ldap_next_attribute (LDAP *ld, LDAPMessage *entry, BerElement *ber){
  char *rv;
  if ((NULL==ld)||(NULL==entry)) {
    ld->ld_errno=LDAP_PARAM_ERROR;
    return NULL;
  }
  if(!((&entry->message->m_protocolOp.GetObject())->IsClass("LDAP_SearchResponse")  &&
       entry->message->m_protocolOp.GetTag()==LDAP_SearchResponse::e_entry)) {
    ld->ld_errno=LDAP_PARAM_ERROR;
    return NULL;
  }
  LDAP_SearchResponse &res=entry->message->m_protocolOp;
  LDAP_SearchResponse_entry &ent=res;
  if (ent.m_attributes.GetSize() <= ber->number) {
    ld->ld_errno=LDAP_PARAM_ERROR;
    return NULL;
  }
  rv=strndup((char *)ent.m_attributes[ber->number].m_type.GetPointer(),
	     ent.m_attributes[ber->number].m_type.GetSize());
  ber->number++;
  return rv;
}

char ** ldap_get_values (LDAP *ld, LDAPMessage *entry, LDAP_CONST char *target) {
  PINDEX number;
  if ((NULL==ld)||(NULL==entry)) {
    ld->ld_errno=LDAP_PARAM_ERROR;
    return NULL;
  }
  if(!(&(entry->message->m_protocolOp.GetObject()))->IsClass("LDAP_SearchResponse")) {
    LDAP_SearchResponse &res=entry->message->m_protocolOp;
      if(res.GetTag()!=LDAP_SearchResponse::e_entry) {
	ld->ld_errno=LDAP_PARAM_ERROR;
	return NULL;
      }
  }
  LDAP_SearchResponse &res=entry->message->m_protocolOp;
  LDAP_SearchResponse_entry &ent=res;
  for(number=0; number < ent.m_attributes.GetSize(); number++)
      if (strncasecmp((char *)ent.m_attributes[number].m_type.GetPointer(),
          target,strlen(target))==0)
        break;
  if (ent.m_attributes.GetSize()<=number) {
    ld->ld_errno=LDAP_PARAM_ERROR;
    return NULL;
  }
  LDAP_SearchResponse_entry_attributes_subtype &response=ent.m_attributes[number];
  char **ret=new (char *)[response.m_values.GetSize()+1];
  for (PINDEX i=0; i<response.m_values.GetSize(); i++)
    ret[i]=strndup((char *)response.m_values[i].GetPointer(),
		   response.m_values[i].GetSize());
  ret[response.m_values.GetSize()]=NULL;
  return ret;
}



struct berval ** ldap_get_values_len (LDAP *ld, LDAPMessage *entry, LDAP_CONST char *target){
  PINDEX number;
  if ((NULL==ld)||(NULL==entry)) {
    ld->ld_errno=LDAP_PARAM_ERROR;
    return NULL;
  }
  if(!(&(entry->message->m_protocolOp.GetObject()))->IsClass("LDAP_SearchResponse")) {
    LDAP_SearchResponse &res=entry->message->m_protocolOp;
      if(res.GetTag()!=LDAP_SearchResponse::e_entry) {
	ld->ld_errno=LDAP_PARAM_ERROR;
	return NULL;
      }
  }
  LDAP_SearchResponse &res=entry->message->m_protocolOp;
  LDAP_SearchResponse_entry &ent=res;
  for(number=0;
      strncmp((char *)ent.m_attributes[number].m_type.GetPointer(),target,strlen(target))!=0;
      number++) {
    if (ent.m_attributes.GetSize()<number) {
      ld->ld_errno=LDAP_PARAM_ERROR;
      return NULL;
    }
  }
  LDAP_SearchResponse_entry_attributes_subtype &response=ent.m_attributes[number];
#ifdef DEBUG
  cerr << response << endl;
#endif
  struct berval **ret=new (struct berval*)[response.m_values.GetSize()+1];
  for (PINDEX i=0; i<response.m_values.GetSize(); i++) {
#ifdef DEBUG
    cerr << "number: " << i << endl;
    cerr << response.m_values[i] << endl;
#endif
    struct berval* bv=new struct berval;
    bv->bv_len=response.m_values[i].GetSize();
    bv->bv_val=strndup((char *)response.m_values[i].GetPointer(),bv->bv_len);
    ret[i]=bv;
  }
  ret[response.m_values.GetSize()]=NULL;
  return ret;
}

int ldap_count_values (char **vals) {
  int number=0;
  while(NULL!=vals[number])
    number++;
  return number;
}

int ldap_count_values_len (struct berval **vals){
  int number=0;
  while(NULL!=vals[number])
    number++;
  return number;
}

//
// End of getattr.cxx
//
