// -*- mode: c++ -*-
// Copyright (C) 2002 mediaWays GmbH Internet-Services, Verl, Germany
//
// PURPOSE OF THIS FILE: Implement the ldap_modify and ldap_modrdn
//                       functions
//
// - Automatic Version Information via RCS:
//   $Id: ldapmodify.cxx,v 1.1 2002/09/23 07:28:52 robertj Exp $
//   $Source: /home/cvsroot/openh323/src/ldapmodify.cxx,v $

/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations under
 * the License.
 *
 * The Original Code is the OpenLDAP Comatible LDAP-API for OpenH323
 * (libldapapi).
 *
 * The Initial Developer of the Original Code is
 * mediaWays GmbH Internet-Services, Verl, Germany
 * Portions created by the Initial Developer are Copyright (C) 2002
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Nils Bokermann <Nils.Bokermann@mediaWays.net> (*)
 *                 Martin Frhlich <Martin.Froehlich@mediaWays.net> (*)
 *
 * (*) Contributors marked this way are mediaWays employees, all their work
 *     is subject to mediaWays copyright by their contracts.
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * For copies of the GPL or LGPL, see either http://www.fsf.org/licenses/
 * or write to the Free Software Foundation, Inc., 59 Temple Place - Suite
 * 330, Boston, MA 02111-1307, USA.
 *
 * ***** END LICENSE BLOCK ***** */

#include <ptlib.h>
#include <ldapapi.h>
#include "ldap-int.h"

#ifndef lint
// mark object with version info in such a way that it is retrievable by
// the std. version/revision control tools like RCS/CVS ident cmd.. At
// least the strings cmd will extract this info.
volatile static const char vcid[] = "@(#) $Id: ldapmodify.cxx,v 1.1 2002/09/23 07:28:52 robertj Exp $";
volatile static const char vcHid[] = LDAP_OPENH323_H;
#endif

int ldap_modify_ext (LDAP *ld, LDAP_CONST char *dn, LDAPMod **mods, LDAPControl **serverctrls,
		     LDAPControl **clientctrls, int *msgidp ) {
  if(NULL==ld)
    return LDAP_UNAVAILABLE;
  LDAP_LDAPMessage msg;

  *msgidp=++(ld->msg_id);
  msg.m_messageID=*msgidp;
  msg.m_protocolOp=LDAP_LDAPMessage_protocolOp(LDAP_LDAPMessage_protocolOp::e_modifyRequest);
  LDAP_ModifyRequest &modify=msg.m_protocolOp;
  modify.m_object=dn;
  LDAP_ModifyRequest_modifications &ldapmod=modify.m_modifications;

  LDAPMod **mod=mods;

  for(PINDEX number=0;NULL!=*mod;number++) {
    if(ldapmod.GetSize()<=number)
      ldapmod.SetSize(number+1);
    ldapmod[number].m_operation=((*mod)->mod_op & (LDAP_MOD_ADD | LDAP_MOD_DELETE | LDAP_MOD_REPLACE)); // only bit 0 and 1.
    if((*mod)->mod_op & LDAP_MOD_BVALUES) { // mod_bvalue
      ldapmod[number].m_modification.m_type=(*mod)->mod_type;
      for(PINDEX attribute=0;NULL!=(*mod)->mod_bvalues[attribute];attribute++){
	if(ldapmod[number].m_modification.m_values.GetSize()<=attribute)
	  ldapmod[number].m_modification.m_values.SetSize(attribute+1);
	ldapmod[number].m_modification.m_values[attribute].SetValue(PASN_OctetString((*mod)->mod_bvalues[attribute]->bv_val,
										     (*mod)->mod_bvalues[attribute]->bv_len));
      }
    } else {
      ldapmod[number].m_modification.m_type=(*mod)->mod_type;
      for(PINDEX attribute=0;NULL!=(*mod)->mod_values[attribute];attribute++){
	if(ldapmod[number].m_modification.m_values.GetSize()<=attribute)
	  ldapmod[number].m_modification.m_values.SetSize(attribute+1);
	ldapmod[number].m_modification.m_values[attribute]=(*mod)->mod_values[attribute];
      }
    }
    mod++;
  }


  PBER_Stream encoding_stream;
  msg.Encode(encoding_stream);
  if(encoding_stream.Write(*(ld->socket))) {
    return LDAP_SUCCESS;
  }
  ld->ld_errno=LDAP_UNAVAILABLE;
  return ld->ld_errno;
}

int ldap_modify_ext_s (LDAP *ld, LDAP_CONST char *dn, LDAPMod **mods,
		       LDAPControl **serverctrls, LDAPControl **clientctrls ) {
  int msgid;
  int rv;
  LDAPMessage *result;

  if(LDAP_SUCCESS!=(rv=ldap_modify_ext(ld, dn, mods, serverctrls, clientctrls,&msgid))) {
    ld->ld_errno=rv;
    return ld->ld_errno;
  }

  if (ldap_result(ld, msgid, 1, NULL, &result) == -1) {
    return( ld->ld_errno );	/* ldap_result sets ld_errno */
  }

  rv = ldap_result2error(ld, result, 0);
  ldap_msgfree(result);
  return rv;
}

int ldap_modify (LDAP *ld, LDAP_CONST char *dn,	LDAPMod **mods) {
  int msgid;
  int rv;
  if(LDAP_SUCCESS!=(rv=ldap_modify_ext(ld, dn, mods, NULL, NULL, &msgid))) {
    ld->ld_errno=rv;
    return -1;
  }
  return msgid;
}

int ldap_modify_s (LDAP *ld, LDAP_CONST char *dn, LDAPMod **mods) {
  int msgid,rv;
  LDAPMessage *result;
  if (-1==(msgid=ldap_modify(ld, dn, mods))){
    return ld->ld_errno;
  }
  if (ldap_result(ld, msgid, 1, NULL, &result) == -1) {
    return( ld->ld_errno );	/* ldap_result sets ld_errno */
  }

  rv = ldap_result2error(ld, result, 0);
  ldap_msgfree(result);
  return rv;
}


int ldap_modrdn2 (LDAP *ld, LDAP_CONST char *dn, LDAP_CONST char *newrdn, int deleteold) {
  LDAP_LDAPMessage msg;
  msg.m_messageID=++(ld->msg_id);
  msg.m_protocolOp=LDAP_LDAPMessage_protocolOp(LDAP_LDAPMessage_protocolOp::e_modifyRDNRequest);
  LDAP_ModifyRDNRequest &rdn=msg.m_protocolOp;
  rdn.m_entry=dn;
  rdn.m_newrdn=newrdn;
#ifdef V2PLUS
  rdn.m_deleteold=deleteold;
#endif

#ifdef DEBUG
  cerr << msg << endl;
#endif
  PBER_Stream encoding_stream;

  msg.Encode(encoding_stream);

#ifdef V2P_WITH_V2ASN
  // Very dangerous. Adding bool to the stream.

  encoding_stream[1]=encoding_stream[1]+3;
  encoding_stream[encoding_stream.GetPosition()]=1;
  encoding_stream[encoding_stream.GetPosition()+1]=1;
  encoding_stream[encoding_stream.GetPosition()+2]=1;
  encoding_stream.SetPosition(encoding_stream.GetPosition()+3);
#endif
#ifdef BER_DEBUG
  cerr << encoding_stream << endl;
#endif
  if(encoding_stream.Write(*(ld->socket))) {
    return ld->msg_id;
  }
  ld->ld_errno=LDAP_UNAVAILABLE;
  return -1;
}

int ldap_modrdn (LDAP *ld, LDAP_CONST char *dn, LDAP_CONST char *newrdn){
  return ldap_modrdn2(ld, dn, newrdn, 1);
}
int ldap_modrdn_s (LDAP *ld, LDAP_CONST char *dn, LDAP_CONST char *newrdn){
  int msgid,rv;
  LDAPMessage *result;
  if(-1==(msgid=ldap_modrdn(ld, dn, newrdn)))
    return ld->ld_errno;

  if (ldap_result(ld, msgid, 1, NULL, &result) == -1) {
    return( ld->ld_errno );	/* ldap_result sets ld_errno */
  }

  rv = ldap_result2error(ld, result, 0);
  ldap_msgfree(result);
  return rv;
}

int ldap_modrdn2_s (LDAP *ld, LDAP_CONST char *dn, LDAP_CONST char *newrdn, int deleteold){
  int msgid,rv;
  LDAPMessage *result;
  if(-1==(msgid=ldap_modrdn2(ld, dn, newrdn, deleteold)))
    return ld->ld_errno;

  if (ldap_result(ld, msgid, 1, NULL, &result) == -1) {
    return( ld->ld_errno );	/* ldap_result sets ld_errno */
  }

  rv = ldap_result2error(ld, result, 0);
  ldap_msgfree(result);
  return rv;
}
//
// End of modify.cxx
//
