/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __ARTICLE_LIST_H__
#define __ARTICLE_LIST_H__

#include <gdk/gdk.h>
#include <gtk/gtkstyle.h>
#include <gtk/gtkctree.h>

#include <pan/base/article.h>
#include <pan/base/group.h>
#include <pan/base/pan-callback.h>
#include <pan/base/status-item.h>

#include <pan/filters/filter.h>

extern GdkColor killfile_color;
extern GdkColor watched_color;

/****
***** 
****/



/**
***  State Info
**/

Group*         articlelist_get_group                    (void);
void           articlelist_set_threaded                 (gboolean threaded_on);
GtkCTreeNode*  articlelist_get_selected_node            (void);
Article*       articlelist_get_selected_article_nolock  (void);
GPtrArray*     articlelist_get_selected_articles_nolock (void);
guint          articlelist_get_selected_count_nolock    (void);

/**
***  Stepping Through the Articles
**/

gboolean articlelist_has_prev_read (void);

GtkCTreeNode* articlelist_node_next (GtkCTreeNode*);
GtkCTreeNode* articlelist_node_prev (GtkCTreeNode*, gboolean sibling_only);
void articlelist_set_selected_nodes_nolock (GtkCTreeNode**, int qty);

void articlelist_reset_style_nolock        (void);

void articlelist_read_next                 (void);
void articlelist_read_next_unread          (void);
void articlelist_read_next_thread          (void);
void articlelist_read_next_unread_thread   (void);
void articlelist_read_prev                 (void);
void articlelist_read_prev_thread          (void);
void articlelist_read_prev_read            (void);
void articlelist_read_top_of_thread        (void);
void articlelist_read_parent               (void);
void articlelist_read_message_id           (const gchar * message_id);

/**
***  Contents
**/

void articlelist_set_group (Group*);
void articlelist_refresh (void);
void articlelist_read_selected (void);

/**
***  Perform Operations on Articles
**/

void articlelist_expand_selected_threads (void);
void articlelist_collapse_selected_threads (void);

void articlelist_select_all_nolock (void);
void articlelist_deselect_all_nolock (void);
void articlelist_add_replies_to_selection_nolock (void);
void articlelist_add_thread_to_selection_nolock (void);

/**
***  Life Cycle
**/

GtkWidget* create_articlelist_ctree (void);


/****
*****  CALLBACKS
****/

/**
 * called whenever the article tree's active group changes.
 *
 * @param call_object the article ctree
 * @param call_arg the new active group
 */
PanCallback* articlelist_get_group_changed_callback (void);

/**
 * called whenever the article tree's selection state changes.
 *
 * @param call_object the article ctree
 * @param call_arg article of the selected article, or NULL if none
 */
extern PanCallback* articlelist_selection_changed;


/***
****
***/

void articlelist_selected_mark_read_nolock (void);
void articlelist_selected_mark_unread_nolock (void);
void articlelist_selected_flag_for_dl_nolock (void);
void articlelist_selected_unflag_for_dl_nolock (void);
void articlelist_selected_download_nolock (void);
void articlelist_selected_thread_watch_nolock (void);
void articlelist_selected_thread_ignore_nolock (void);
void articlelist_spamize_nolock (void);
void articlelist_selected_copy_to_folder_nolock (void);
void articlelist_selected_cancel (void);
void articlelist_selected_supersede (void);


#endif /* __ARTICLE_LIST_H__ */
