/*
 * All the code used here was torn by Marc Prud'hommeaux out of the 
 * Samba project (by Andrew Tridgell, Jeremy Allison, and others).
 */

typedef signed short int16;
typedef unsigned short uint16;
typedef unsigned uint32;
typedef unsigned char  uint8;

typedef struct
{
	uint16			len;
	uint16			maxlen;
	uint32			offset;
} SPAStrHeader;

typedef struct
{
	char			ident[8];
	uint32			msgType;
	SPAStrHeader	uDomain;
	uint32			flags;
	uint8			challengeData[8];
	uint8			reserved[8];
	SPAStrHeader	emptyString;
	uint8			buffer[1024];
	uint32			bufIndex;
} SPAAuthChallenge;


typedef struct
{
	char			ident[8];
	uint32			msgType;
	uint32			flags;
	SPAStrHeader	user;
	SPAStrHeader	domain;
	uint8			buffer[1024];
	uint32			bufIndex;
} SPAAuthRequest;

typedef struct
{
	char			ident[8];
	uint32			msgType;
	SPAStrHeader	lmResponse;
	SPAStrHeader	ntResponse;
	SPAStrHeader	uDomain;
	SPAStrHeader	uUser;
	SPAStrHeader	uWks;
	SPAStrHeader	sessionKey;
	uint32			flags;
	uint8			buffer[1024];
	uint32			bufIndex;
} SPAAuthResponse;

#define spa_request_length(ptr) (((ptr)->buffer - (uint8*)(ptr)) + (ptr)->bufIndex)

void spa_bits_to_base64 (unsigned char *, const unsigned char *, int);
int spa_base64_to_bits (char *out, const char *in);
void spa_build_auth_response (SPAAuthChallenge *challenge, 
	SPAAuthResponse *response, char *user, char *password);
void spa_build_auth_request (SPAAuthRequest *request, char *user, 
	char *domain);

