/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>
#include <string.h>
#include <pan/base/pan-callback.h>

/* arbitrary number; can be changed if needed */
#define MAX_LISTENERS 8

typedef struct
{
	struct
	{
		PanCallbackFunc callback;
		gpointer user_data;
	}
	listeners [MAX_LISTENERS];

	int qty;
}
Impl;

/**
***  Public Interface
**/

PanCallback*
pan_callback_new (void)
{
	PanCallback * pcl = g_new0 (PanCallback, 1);
	pcl->impl = g_new0 (Impl, 1);
	return pcl;
}

void
pan_callback_free (PanCallback* pcl)
{
	g_free (pcl->impl);
	g_free (pcl);
}

		 
void
pan_callback_call (PanCallback* pcl, gpointer call_object, gpointer call_arg)
{
	int i;
	Impl impl = *(Impl*) pcl->impl;

	for (i=0; i<impl.qty; ++i)
		(*impl.listeners[i].callback)(call_object,
		                              call_arg,
		                              impl.listeners[i].user_data);
}

void
pan_callback_add (PanCallback* pcl, PanCallbackFunc cb, gpointer user)
{
	Impl * impl = (Impl*) pcl->impl;

	if (impl->qty >= MAX_LISTENERS)
		g_warning ("Too many listeners to pan_callback %p", pcl);
	else {
		const int qty = impl->qty++;
		impl->listeners[qty].callback = cb;
		impl->listeners[qty].user_data = user;
	}
}

void
pan_callback_remove (PanCallback* pcl, PanCallbackFunc cb, gpointer user)
{
	int i;
	Impl * impl = (Impl*) pcl->impl;

	for (i=0; i<impl->qty; ++i)
		if (impl->listeners[i].callback == cb &&
		    impl->listeners[i].user_data == user)
			break;

	if (i!=impl->qty) {
		const int qty = impl->qty--;
		g_memmove (impl->listeners+i,
		           impl->listeners+i+1,
		           sizeof(impl->listeners[0])*qty-1-i);
	}
}
