/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>

#include <glib.h>

#include <pan/base/acache.h>
#include <pan/base/pan-i18n.h>

#include <pan/filters/filter-cached.h>

const char * FILTER_CACHED_CLASS_ID = "PanObject::Filter::FilterCached";

/************
*************  PROTECTED
************/

static Filter*
filter_cached_dup (const Filter * f_old)
{
	Filter * f_new = filter_cached_new ();
	filter_class_dup (f_old, f_new);
	return f_new;
}

static char*
filter_cached_to_string (const Filter * filter)
{
	char * pch;

	if (filter->negate)
		pch = g_strdup (_("Article body isn't cached locally"));
	else
		pch = g_strdup (_("Article body is cached locally"));

	return pch;
}

static void
filter_cached_test_articles (Filter          * filter,
                             const Article  ** articles,
                             int               article_qty,
                             gboolean        * passfail)
{
	int i;

	for (i=0; i<article_qty; ++i)
		passfail[i] = acache_has_message (article_get_message_id(articles[i]));
}

/************
*************  PUBLIC
************/

Filter*
filter_cached_new (void)
{
	FilterCached * f = g_new0 (FilterCached, 1);
	filter_constructor ((Filter*)f,
	                    filter_destructor,
	                    filter_cached_test_articles,
	                    filter_cached_to_string,
	                    filter_cached_dup,
	                    FILTER_CACHED_CLASS_ID);
	return FILTER(f);
}
