/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __PREFS_H__
#define __PREFS_H__

/**
*** Global Variables
**/

extern gboolean                remove_failed_tasks;
extern gboolean                single_click_selects;
extern gboolean                header_pane_is_threaded;
extern gboolean                show_group_pane;
extern gboolean                show_header_pane;
extern gboolean                show_body_pane;
extern gboolean                text_use_fixed_font;
extern gboolean                text_window_smooth_scrolling;
extern int                     text_window_smooth_scrolling_speed;
extern gboolean                fetch_new_on_startup;
extern gboolean                fetch_new_and_bodies_on_startup;
extern gboolean                fetch_new_on_group_load;
extern gboolean                expand_all_threads_by_default;
extern gboolean                hide_mpart_child_nodes;
extern gboolean                pan_mute;
extern char                  * thread_date_format;

extern gboolean                use_custom_fonts;
extern char                  * group_pane_font;
extern char                  * header_pane_font;
extern char                  * message_body_font;
extern char                  * message_body_font_fixed;

extern char                  * external_web_browser;
extern char                  * external_editor;

extern char                  * mail_server_address;
extern char                  * layout_str;
extern int                     mail_server_port;
extern int                     wrap_column;
extern gboolean                collapse_group_names;
extern gboolean                do_spellcheck;



/** 
*** Function Prototypes
**/

void prefs_spawn                         (void);

void prefs_init                          (void);

void show_group_substitution_help_dialog (gpointer window);

#endif /* __PREFS_H__ */
