/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <config.h>

#include <string.h>

#include <glib.h>
#include <gtk/gtk.h>

#include <pan/base/pan-i18n.h>
#include <pan/dialogs/dialogs.h>
#include <pan/dialogs/pan-about.h>

static char * get_credits_code (void);
static char * get_credits_users (void);
static char * get_credits_translators (void);

/**
 * dialog_about:
 *
 * About window to display program information, version number, and
 * copyright.
 **/
void
dialog_about (GtkWidget * window)
{
	char * pch;
	char * credits_bugs;
	char * credits_i18n;
	char * credits_code;
	GtkWidget * about;

	about = pan_about_new (GTK_WINDOW(window),
	                       "Pan", VERSION,
	                       _("A newsreader for GNOME"),
	                       _("Copyright (C) 2002 Charles Kerr"),
	                       PAN_ABOUT_LICENSE_GPL,
	                       "http://pan.rebelbase.com/");

	pan_about_add_author (about, "Charles Kerr", "charles@rebelbase.com",
	                      _("Programmer"));
	pan_about_add_author (about, "Christophe Lambin", "clambin@easynet.be",
	                      _("Programmer"));
	pan_about_add_author (about, "Adam Huffman", "bloch@verdurin.com",
	                      _("Programmer & Documentation"));
	pan_about_add_author (about, "Matt Eagleson", "e.Messiah@superpimp.org",
	                      _("Project Originator, Programmer"));
	pan_about_add_author (about, "Jason Leach", NULL,
	                      _("Programmer, 0.6 - 0.7"));

	credits_i18n = get_credits_translators ();
	credits_code = get_credits_code ();
	credits_bugs = get_credits_users ();
	pch = g_strdup_printf (_("Pan %s Translations\n%s\n"
                                 "\n"
                                 "Pan %s Code or Patches\n%s\n"
                                 "\n"
                                 "Pan %s Suggestions and Testing\n%s\n"
                                 "\n"
	                         "Contributors to previous versions are listed at\n"
	                         "http://pan.rebelbase.com/CREDITS"),
	                         VERSION, credits_i18n,
	                         VERSION, credits_code,
	                         VERSION, credits_bugs);
	pan_about_add_text (about, _("Thanks"), pch);
	g_free (credits_i18n);
	g_free (credits_code);
	g_free (credits_bugs);
	g_free (pch);

	gtk_widget_show (about);
}


static char *
get_credits_translators (void)
{
	const char * str =
"\n\tcs - Michal Bukovjan"
"\n\tde - Benjamin Greiner"
"\n\tes - Pablo Gonzalo del Campo"
"\n\tet - Tivo Leedjrv"
"\n\tja - Takayuki KUSANO"
"\n\tnl - Reinout van Schouwen"
"\n\tsv - Christian Rose"
"\n\tvi - pclouds";
	return g_convert (str, strlen(str), "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
}

static char *
get_credits_code (void)
{
	const char * str =
"\n\tBrandon Corey";
	return g_convert (str, strlen(str), "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
}

static char *
get_credits_users (void)
{
	const char * str = 
"\n\tAlan Bailward (#91365)"
"\n\tJames Brost (#100904)"
"\n\tBobby D. Bryant (#100695)"
"\n\tChill"
"\n\tSid Cowles (#99218)"
"\n\tWendell Dingus (#90378)"
"\n\tDuncan"
"\n\tTom F."
"\n\tBo Flynn (#100605)"
"\n\tGollum (#93713, #93894)"
"\n\tDon Horsman (#97527)"
"\n\tKang Jeong-Hee (#87553)"
"\n\tJohan (#909070)"
"\n\tCarl Hudkins (#85153)"
"\n\tChristian Lohmaier (#89281)"
"\n\tJean-Marc (#91536)"
"\n\tMaurizio (#101013)"
"\n\tBas Mevissen (#89435)"
"\n\tLeonard Nutley (#93169)"
"\n\tChris Petersen (#94863)"
"\n\tJens Petersen (#99873)"
"\n\tWill Robinson (#97710)"
"\n\tMartin Schrode (#98463)"
"\n\tJerry Segers (#97778)"
"\n\tMarcin Wojtczuk (#67554)";
	return g_convert (str, strlen(str), "UTF-8", "ISO-8859-1", NULL, NULL, NULL);
}
