/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Pan - A Newsreader for Gtk+
 * Copyright (C) 2002  Charles Kerr <charles@rebelbase.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __TASK__H__
#define __TASK__H__

#include <glib.h>

#include <pan/base/message-identifier.h>
#include <pan/base/pan-callback.h>
#include <pan/base/server.h>
#include <pan/base/status-item.h>
#include <pan/base/article.h>

#include <pan/sockets.h>

/**
***  TASK CLASS DEFINITION
**/

enum
{
	TASK_SUCCESS			=  0, /* done */
	TASK_FAIL			= -1, /* failed; retry */
	TASK_FAIL_HOPELESS		= -2  /* failed; don't retry */
};

enum
{
	TASK_TYPE_OTHER,
	TASK_TYPE_BODY,
	TASK_TYPE_BODIES,
	TASK_TYPE_HEADERS,
	TASK_TYPE_SAVE,
	TASK_TYPE_POST
};

#define TASK(a) ((Task*)a)
typedef struct _Task Task;
typedef int (*TaskRunFunc)(Task*);
struct _Task
{
	/* Parent Class */
	StatusItem parent;

	/* Public Fields */
	PanCallback * task_ran_callback;

	/* Private Fields */  
	guint gets_bodies        : 1;
	guint is_article_reader  : 1;
	guint high_priority      : 1;
	guint needs_socket       : 1;
	gint8 tries;
	gint8 type;
	gboolean hint_abort;
	gboolean is_running;
	Server * server;
	PanSocket * sock;
	GPtrArray * identifiers;

	/* virtual functions */
	TaskRunFunc run;
};

/**
***  PROTECTED
**/

void task_destructor      (PanObject                 * object);

void task_constructor     (Task                      * task,
                           PanObjectDestructor         dtor,
                           StatusItemDescribeFunc      describe,
                           TaskRunFunc                 run,
                           Server                    * server,
                           gboolean                    high_priority,
                           gboolean                    needs_socket);

/**
***  PUBLIC
**/

int          task_run                 (Task                 * task);

void         task_hint_abort          (Task                 * task);

void         task_add_identifiers     (Task                 * task,
                                       MessageIdentifier   ** identifiers,
                                       int                    identifier_qty);

GPtrArray*   task_get_identifiers      (Task                * task);


#endif
