#define RADIO_SIZE 13
#define CHECK_SIZE 13

#define SCALE_SIZE 5

typedef struct 
{
  guint refcount;
  GdkColor spot_color;
  gboolean has_spot_color;
  double contrast;
  guint wide;
} BluecurveRcData;

typedef struct 
{
  GdkColor gray[8];

  GdkColor spot_color;
  GdkColor spot1;
  GdkColor spot2;
  GdkColor spot3;

  /* from light to dark */
  GdkGC *gray_gc[8];

  GdkGC *spot1_gc;
  GdkGC *spot2_gc;
  GdkGC *spot3_gc;
  
  GdkPixmap *radio_pixmap_nonactive[5];
  GdkPixmap *radio_pixmap_active[5];
  GdkPixmap *radio_pixmap_inconsistent[5];
  GdkBitmap *radio_pixmap_mask; /* All masks are the same */
  
  GdkPixmap *check_pixmap_nonactive[5];
  GdkPixmap *check_pixmap_active[5];
  GdkPixmap *check_pixmap_inconsistent[5];
} BluecurveData;

void bluecurve_initialize_style (GtkStyleClass *klass,
				  GtkStyleClass *parent);
void bluecurve_shade (GdkColor * a, GdkColor * b, float k);
