/* Tool to scale icons */

/* 
 * Copyright (C) 2002 Red Hat Inc.
 * Developed by Havoc Pennington
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

static void
usage (void)
{
  g_printerr ("scale-icon WIDTH HEIGHT SRCFILE DESTFILE\n");
  exit (1);
}

int
main (int argc, char **argv)
{
  int width;
  int height;
  const char *width_str;
  const char *height_str;
  const char *srcfile;
  const char *destfile;
  GdkPixbuf *src;
  GdkPixbuf *dest;
  GError *err;
  
  if (argc != 5)
    usage ();

  width_str = argv[1];
  height_str = argv[2];
  srcfile = argv[3];
  destfile = argv[4];
  
  width = atoi (width_str);
  height = atoi (height_str);

  if (width <= 0 || width > 1024)
    {
      g_printerr ("Width %d is on crack\n", width);
      exit (1);
    }
  if (height <= 0 || height > 1024)
    {
      g_printerr ("Height %d is on crack\n", height);
      exit (1);
    }

  g_type_init ();
  
  err = NULL;
  src = gdk_pixbuf_new_from_file (srcfile, &err);
  if (err != NULL)
    {
      g_printerr ("Failed to load %s: %s\n",
                  srcfile, err->message);
      g_error_free (err);
      exit (1);
    }

  dest = gdk_pixbuf_scale_simple (src,
                                  width, height,
                                  GDK_INTERP_BILINEAR);
  
  err = NULL;
  gdk_pixbuf_save (dest, destfile,
                   "png", &err, NULL);
  if (err != NULL)
    {
      g_printerr ("Failed to save %s: %s\n",
                  destfile, err->message);
      g_error_free (err);
      exit (1);
    }
  
  return 0;
}
