Summary:       Sticky Notes for the Gnome Desktop Environment
Name:          stickynotes_applet
Version:       1.2.0
Release:       1mdk
License:       GPL
Group:         User Interface/GNOME Applets
Source:        stickynotes_applet-1.2.0.tar.gz
Packager:      Loban A Rahman <loban@earthling.net>
Buildroot:     /var/tmp/%{name}-root
Requires:      pkgconfig, libgnome2_0, libgnomecanvas2_0, libbonobo2_0, libatk1.0_0
Requires:      libbonoboui2_0, libpango1.0_0, libglib2.0_0, libgtk+2.0_0, libbonobo-activation4
Requires:      libpanel-applet-2_0, libgnomeui2_0, liblinc1, libGConf2_4, ORBit2_0
BuildRequires: pkgconfig, libgnome2_0-devel, libgnomecanvas2_0-devel, libbonobo2_0-devel, libatk1.0_0-devel
BuildRequires: libbonoboui2_0-devel, libpango1.0_0-devel, libglib2.0_0-devel, libgtk+2.0_0-devel, libbonobo-activation4-devel
BuildRequires: libpanel-applet-2_0, libgnomeui2_0-devel, liblinc1-devel, libGConf2_4-devel, libORBit2_0-devel

%description
A Gnome 2.2 applet that allows you to create, view and manage sticky notes on your desktop.

%prep
%setup -q
%configure

%build
make

%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT
%makeinstall

# Remove scrollkeeper generated files to prevent unpackaged file warnings
/bin/rm -rf $RPM_BUILD_ROOT/var/lib/scrollkeeper

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
SCHEMAS="stickynotes.schemas"
for S in $SCHEMAS; do
  gconftool-2 --makefile-install-rule %{_sysconfdir}/gconf/schemas/$S  &>/dev/null
done

%preun

%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%files
%defattr(755,root,root,755)
%{_libexecdir}/stickynotes_applet
%defattr(644,root,root,755)
%doc AUTHORS COPYING README NEWS TODO ChangeLog
%{_datadir}/stickynotes
%{_datadir}/pixmaps/stickynotes
%{_datadir}/gnome/help/stickynotes_applet
%{_datadir}/omf/stickynotes_applet
%{_datadir}/gnome-2.0/ui
%{_datadir}/locale
%{_sysconfdir}/gconf
%{_libdir}/bonobo

%changelog
* Tue Jun 03 2003 Loban A Rahman <loban@earthling.net>
- Updated description
- Changed a few filenames and paths

* Thu Dec 26 2002 Chris Chabot <chabotc@xs4all.nl>
- Cleanup spec file
- Use rh macro's for configure and makeinstall
- Added omf and gnome help to %files list
- Cleaned up makeinstall process to prevent missing file warnings
- Added a (reasonably complete) Requires and BuildRequires list
- Made schema install on rpm-install quiet (bad form not to)
- Work-around for doc install errors
- Remove scrollkeeper generated files to prevent missing-file errors
- Removed overly used @package@ macro's from .in (makes it less readable
  and if your gonna rename it, do a search & replace please ;-)

* Sun Dec 02 2002 Loban A Rahman <loban@earthling.net>
- Initial specfile written
