/* 
 * Copyright (C) 2002 Bastien Nocera <hadess@hadess.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: totem-cd-selection.h,v 1.4 2002/12/13 12:50:54 hadess Exp $
 *
 * Authors: Bastien Nocera <hadess@hadess.net>
 */

#ifndef HAVE_TOTEM_CD_SELECTION_H
#define HAVE_TOTEM_CD_SELECTION_H

#include <gtk/gtkwidget.h>

G_BEGIN_DECLS

#define TOTEM_CD_SELECTION(obj)              (GTK_CHECK_CAST ((obj), totem_cd_selection_get_type (), TotemCdSelection))
#define TOTEM_CD_SELECTION_CLASS(klass)      (GTK_CHECK_CLASS_CAST ((klass), totem_cd_selection_get_type (), TotemCdSelectionClass))
#define TOTEM_IS_CD_SELECTION(obj)           (GTK_CHECK_TYPE (obj, totem_cd_selection_get_type ()))
#define TOTEM_IS_CD_SELECTION_CLASS(klass)   (GTK_CHECK_CLASS_TYPE ((klass), totem_cd_selection_get_type ()))

typedef struct TotemCdSelectionPrivate TotemCdSelectionPrivate;

typedef struct {
	GtkVBox widget;
	TotemCdSelectionPrivate *priv;
} TotemCdSelection;

typedef struct {
	GtkVBoxClass parent_class;
	void (*device_changed) (GtkWidget *gtx, const char *title);
} TotemCdSelectionClass;

GtkType totem_cd_selection_get_type              (void);
GtkWidget *totem_cd_selection_new                (void);

void totem_cd_selection_set_device		 (TotemCdSelection *tcs,
						  const char *device);
const char *totem_cd_selection_get_device	 (TotemCdSelection *tcs);
const char *totem_cd_selection_get_default_device (TotemCdSelection *tcs);

G_END_DECLS

#endif				/* HAVE_TOTEM_CD_SELECTION_H */
