/* X-Chat
 * Copyright (C) 1998 Peter Zelezny.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */

#define GTK_DISABLE_DEPRECATED

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "fe-gtk.h"

#include <gtk/gtkmain.h>
#include <gtk/gtkcontainer.h>
#include <gtk/gtkentry.h>
#include <gtk/gtkvbox.h>
#include <gtk/gtkhbox.h>
#include <gtk/gtkwindow.h>
#include <gtk/gtklabel.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtkhseparator.h>

#ifdef USE_XLIB
#include <gdk/gdkx.h>
#endif

#include "../common/xchat.h"
#include "../common/util.h"
#include "palette.h"
#include "gtkutil.h"
#include "about.h"


#ifdef USE_GNOME

void
menu_about (GtkWidget * wid, gpointer sess)
{
	char buf[512];
	const gchar *author[] = { "Peter Zelezny <zed@xchat.org>", 0 };

	(snprintf) (buf, sizeof (buf),
				 "An IRC Client for UNIX.\n\n"
				 "This binary was compiled on "__DATE__"\n"
				 "Using GTK %d.%d.%d X %d\n"
				 "Running on %s",
				 gtk_major_version, gtk_minor_version, gtk_micro_version,
#ifdef USE_XLIB
				VendorRelease (GDK_DISPLAY ()), get_cpu_str());
#else
				666, get_cpu_str());
#endif

	gtk_widget_show (gnome_about_new ("X-Chat", VERSION,
							"(C) 1998-2002 Peter Zelezny", author, buf, 0));
}

#else

static GtkWidget *about = 0;

static int
about_close (void)
{
	about = 0;
	return 0;
}

void
menu_about (GtkWidget * wid, gpointer sess)
{
	GtkWidget *vbox, *label, *hbox;
	GtkStyle *about_style;
	GtkStyle *head_style;
	char buf[512];

	if (about)
	{
		gtk_window_present (GTK_WINDOW (about));
		return;
	}
	head_style = gtk_style_new ();
	head_style->fg[GTK_STATE_NORMAL] = colors[2];

	about_style = gtk_style_new ();
	/*gdk_font_unref (about_style->font);
	about_style->font = gdk_font_load ("fixed");*/

	about = gtk_window_new (GTK_WINDOW_POPUP);
	gtk_window_set_position (GTK_WINDOW (about), GTK_WIN_POS_CENTER);
	gtk_window_set_title (GTK_WINDOW (about), _("About X-Chat"));
	gtk_container_set_border_width (GTK_CONTAINER (about), 6);
	g_signal_connect (G_OBJECT (about), "destroy",
							G_CALLBACK (about_close), 0);
	gtk_widget_realize (about);

	vbox = gtk_vbox_new (0, 2);
	gtk_container_add (GTK_CONTAINER (about), vbox);
	/*gtk_widget_show (vbox);*/

	label = gtk_entry_new ();
	gtk_editable_set_editable (GTK_EDITABLE (label), FALSE);
	gtk_entry_set_text (GTK_ENTRY (label), "X-Chat " VERSION);
	gtk_widget_set_style (label, head_style);
	g_object_unref (head_style);
	gtk_container_add (GTK_CONTAINER (vbox), label);

	(snprintf) (buf, sizeof (buf),
				 "(C) 1998-2002 Peter Zelezny <zed@xchat.org>\n\n"
				 "An IRC Client for UNIX.\n\n"
				 "This binary was compiled on "__DATE__"\n"
				 "Using GTK %d.%d.%d X %d\n"
				 "Running on %s\n",
				 gtk_major_version, gtk_minor_version, gtk_micro_version,
#ifdef USE_XLIB
				VendorRelease (GDK_DISPLAY ()), get_cpu_str());
#else
				666, get_cpu_str());
#endif

	label = gtk_label_new (buf);
	gtk_container_add (GTK_CONTAINER (vbox), label);
	gtk_widget_set_style (label, about_style);
	g_object_unref (about_style);
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);

	wid = gtk_hseparator_new ();
	gtk_container_add (GTK_CONTAINER (vbox), wid);

	hbox = gtk_hbox_new (0, 2);
	gtk_container_add (GTK_CONTAINER (vbox), hbox);

	wid = gtk_button_new_with_label (_("OK"));
	gtk_container_set_border_width (GTK_CONTAINER (hbox), 2);
	GTK_WIDGET_SET_FLAGS (GTK_WIDGET (wid), GTK_CAN_DEFAULT);
	gtk_box_pack_end (GTK_BOX (hbox), wid, 0, 0, 0);
	gtk_widget_grab_default (wid);
	g_signal_connect (G_OBJECT (wid), "clicked",
							G_CALLBACK (gtkutil_destroy), about);

	gtk_widget_show_all (about);
}
#endif
