%define name 	libxine
%define version 1_beta12
%define dirversion 1.0.0
%define release 1

%define major 	1
%define libname	%{name}%{major}

Name:        %{name}
Summary:     A portable video/audio library for unix-like systems.
Summary(cs): Penositeln video/audio knihovna pro unixovsk systmy
Summary(de): Eine portabele Audio-/Video-Bibliothek fr unixartige Systeme.
Summary(fi): Joustava video- ja niohjelmointikirjasto Unix-tyylisille kyttjrjestelmille.
Version:     %{version}
Release:     %{release}
License:     GPL
Group:       Development/Libraries
Source:      http://xinehq.de/files/xine-lib-1-beta12.tar.gz
URL:         http://xinehq.de/
Packager:    Manfred Tremmel <Manfred.Tremmel@iiv.de>
BuildPreReq: zlib
BuildRoot:   %{_tmppath}/%{name}-buildroot

%description
%{name} is the beating heart of xine (a free gpl-licensed video player for
unix-like systems) which among others provides support for decoding (and
playing back) of many today available audio/video codecs, like mpeg-4 (DivX),
mpeg-2 (DVD, SVCD), mpeg-1 (VCD), Quicktime and RealMedia just to name a few.
This library contains (and uses) numerous processor specific optimizations to
provide a smooth playback and to minimize the overall demand of CPU power.

Don't hesitate to use %{name} in your own projects as long as your usage
complies to the GPL. More information about GPL-license can be found at
http://www.gnu.org/licenses/gpl.html

%description -l cs
%{name} je tepajc srdce xine (voln iitelnho videopehrvae pod gpl
licenc pro unixovsk systmy). Mimo jin poskytuje podporu pro dekdovn
(a pehrvn) s mnoha dnes dostupnmi audio/video kodeky jako jsou
nap. mpeg-4, mpeg-2 a mpeg-1. Tato knihovna obsahuje a pouv velk poet
procesorov zvislch optimalizac k dosaen plynulho pehrvn a
zmenen celkovho nroku na vkon procesoru.

Dokud to bude ve shod s GPL, nevhejte pout %{name} ve vaich vlastnch
projektech.

%description -l de
%{name} ist das Herzstck von xine (einem freien, GPL lizensiertem Audio- und
Video-Abspielprogramm fr unixartige Systeme). %{name} stellt die Funktionen
zur Dekodierung und Wiedergabe vieler aktueller Audio- und Videocodecs zur
Verfgung, wie z.B. MPEG-4 (DivX), MPEG-2 (DVD, SVCD) und MPEG-1 (VCD),
Quicktime und RealMedia um nur einige zu nennen.
Die Bibliothek enthlt und benutzt eine Vielzahl von prozessorspezifischen
Optimierungen, um eine flssige Wiedergabe mit minimaler Prozessorbelastung
gewhrleisten zu knnnen.

Zgern Sie nicht %{name} in Ihren eigenen Projekten zu nutzen. Beachten Sie
hierzu jedoch die in der GPL Lizenz vereinbarten Bestimmungen. Weitere
Informationen zur GPL-Lizenz finden Sie unter http://www.gnu.org/licenses/gpl.html

%description -l fi
%{name} on xinen sydn (vapaa GPL-linsensoitu videosoitinohjelma Unix-tyylisille
kyttjrjestelmille), joka muun muassa tarjoaa mahdollisuudet pakatun videon
ja nen purkamiseen (sek nyttmiseen) suurimmalla osalla nykyaikaista nen-
ja kuvanpakkausformaateista.
Tllaisia ovat mpeg-4 (DivX;-)), mpeg-2 (DVD, SVCD), mpeg-1 (VCD) muutamia
mainitaksemme. xinen purkukirjasto kytt monia matalan tason prosessoripohjaisia
optimisaatiomenetelmi tarjotakseen sulavan kuvantoistokokemuksen. Tm on tarpeen
mys minimoimaan tarvittavaa prosessoritehoa.

Olet tervetullut kyttmn %{name}:a omissa projekteissasi kunhan ne ovat GPL-
lisenssin kanssa yhteensopivia. listietoja GPL-lisenssist lytyy osoitteesta:
http://www.gnu.org/licenses/gpl.html

%package -n %{libname}
Summary:   Required libs to run programs dynamically linked with %{name}.
Summary(cs): Knihovny nutn pro bh program dynamicky linkovanch s %{name}
Summary(de): Bentigte Bibliotheken, um Programme, die dynamisch gegen %{name} gelinkt sind, benutzen zu knnen.
Summary(fi): Tarvittavat kirjastot ohjelman ajamiseen linkitettyn %{name}:n kanssa.
Group:	   Development/Libraries
Provides:  %{name} = %{version}-%{release}
Requires:  zlib

%description -n %{libname}
This package is required to run programs dynamically linked with %{name}.

%{name} is the beating heart of xine (a free gpl-licensed video player for
unix-like systems) which among others provides support for decoding (and
playing back) of many today available audio/video codecs, like mpeg-4 (DivX),
mpeg-2 (DVD, SVCD), mpeg-1 (VCD), Quicktime and RealMedia just to name a few.
This library contains (and uses) numerous processor specific optimizations to
provide a smooth playback and to minimize the overall demand of CPU power.

Don't hesitate to use %{name} in your own projects as long as your usage
complies to the GPL. More information about GPL-license can be found at
http://www.gnu.org/licenses/gpl.html

%description -n %{libname} -l cs
Tento balek je nutn pro bh program dynamicky linkovanch s %{name}.

%{name} je tepajc srdce xine (voln iitelnho videopehrvae pod gpl
licenc pro unixovsk systmy). Mimo jin poskytuje podporu pro dekdovn
(a pehrvn) s mnoha dnes dostupnmi audio/video kodeky jako jsou
nap. mpeg-4, mpeg-2 a mpeg-1. Tato knihovna obsahuje a pouv velk poet
procesorov zvislch optimalizac k dosaen plynulho pehrvn a
zmenen celkovho nroku na vkon procesoru.

Dokud to bude ve shod s GPL, nevhejte pout %{name} ve vaich vlastnch
projektech.

%description -n %{libname} -l de
Dieses Paket wird bentigt, um Programme, die dynamisch gegen %{name}
gelinkt sind, benutzen zu knnen.

%{name} ist das Herzstck von xine (einem freien, GPL lizensiertem Audio- und
Video-Abspielprogramm fr unixartige Systeme). %{name} stellt die Funktionen
zur Dekodierung und Wiedergabe vieler aktueller Audio- und Videocodecs zur
Verfgung, wie z.B. MPEG-4 (DivX), MPEG-2 (DVD, SVCD) und MPEG-1 (VCD),
Quicktime und RealMedia um nur einige zu nennen.
Die Bibliothek enthlt und benutzt eine Vielzahl von prozessorspezifischen
Optimierungen, um eine flssige Wiedergabe mit minimaler Prozessorbelastung
gewhrleisten zu knnnen.

Zgern Sie nicht %{name} in Ihren eigenen Projekten zu nutzen. Beachten Sie
hierzu jedoch die in der GPL Lizenz vereinbarten Bestimmungen. Weitere
Informationen zur GPL-Lizenz finden Sie unter http://www.gnu.org/licenses/gpl.html

%description -n %{libname} -l fi
%{name} on xinen sydn (vapaa GPL-linsensoitu videosoitinohjelma Unix-tyylisille
kyttjrjestelmille), joka muun muassa tarjoaa mahdollisuudet pakatun videon
ja nen purkamiseen (sek nyttmiseen) suurimmalla osalla nykyaikaista nen-
ja kuvanpakkausformaateista.
Tllaisia ovat mpeg-4 (DivX;-)), mpeg-2 (DVD, SVCD), mpeg-1 (VCD) muutamia
mainitaksemme. xinen purkukirjasto kytt monia matalan tason prosessoripohjaisia
optimisaatiomenetelmi tarjotakseen sulavan kuvantoistokokemuksen. Tm on tarpeen
mys minimoimaan tarvittavaa prosessoritehoa.

Olet tervetullut kyttmn %{name}:a omissa projekteissasi kunhan ne ovat GPL-
lisenssin kanssa yhteensopivia. listietoja GPL-lisenssist lytyy osoitteesta:
http://www.gnu.org/licenses/gpl.html

%package -n %{libname}-devel
Summary:   Header files and documentation to develope programs with %{name}.
Summary(cs): Hlavikov soubory a dokumentace pro vvoj program pouvajcch %{name}.
Summary(de): Headerdateien und Dokumentationen, um Programme mit %{name} entwickeln zu knnen.
Summary(fi): Header-tiedostot ja dokumentaatio, joita tarvitset kehittesssi ohjelmia %{name}:n kanssa.
Group:	   Development/Libraries
Obsoletes: xine-lib-devel libxine0-devel
Provides:  %{name}-devel = %{version}-%{release}
Requires:  %{libname} = %{version}-%{release}

%description -n %{libname}-devel
This package contains header files and documentation required to develope
programs with %{name}.

%{name} is the beating heart of xine (a free gpl-licensed video player for
unix-like systems) which among others provides support for decoding (and
playing back) of many today available audio/video codecs, like mpeg-4 (DivX),
mpeg-2 (DVD, SVCD), mpeg-1 (VCD), Quicktime and RealMedia just to name a few.
This library contains (and uses) numerous processor specific optimizations to
provide a smooth playback and to minimize the overall demand of CPU power.

Don't hesitate to use %{name} in your own projects as long as your usage
complies to the GPL. More information about GPL-license can be found at
http://www.gnu.org/licenses/gpl.html

%description -n %{libname}-devel -l cs
Tento balek obsahuje hlavikov soubory a dokumentaci potebnou pro vvoj
program pouvajcch %{name}.

%{name} je tepajc srdce xine (voln iitelnho videopehrvae pod gpl
licenc pro unixovsk systmy). Mimo jin poskytuje podporu pro dekdovn
(a pehrvn) s mnoha dnes dostupnmi audio/video kodeky jako jsou
nap. mpeg-4, mpeg-2 a mpeg-1. Tato knihovna obsahuje a pouv velk poet
procesorov zvislch optimalizac k dosaen plynulho pehrvn a
zmenen celkovho nroku na vkon procesoru.

Dokud to bude ve shod s GPL, nevhejte pout %{name} ve vaich vlastnch
projektech.

%description -n %{libname}-devel -l de
Dieses Paket enthlt die Headerdateien und Dokumentationen, um Programme
mit %{name} entwickeln zu knnen.

%{name} ist das Herzstck von xine (einem freien, GPL lizensiertem Audio- und
Video-Abspielprogramm fr unixartige Systeme). %{name} stellt die Funktionen
zur Dekodierung und Wiedergabe vieler aktueller Audio- und Videocodecs zur
Verfgung, wie z.B. MPEG-4 (DivX), MPEG-2 (DVD, SVCD) und MPEG-1 (VCD),
Quicktime und RealMedia um nur einige zu nennen.
Die Bibliothek enthlt und benutzt eine Vielzahl von prozessorspezifischen
Optimierungen, um eine flssige Wiedergabe mit minimaler Prozessorbelastung
gewhrleisten zu knnnen.

Zgern Sie nicht %{name} in Ihren eigenen Projekten zu nutzen. Beachten Sie
hierzu jedoch die in der GPL Lizenz vereinbarten Bestimmungen. Weitere
Informationen zur GPL-Lizenz finden Sie unter http://www.gnu.org/licenses/gpl.html

%description -n %{libname}-devel -l fi
%{name} on xinen sydn (vapaa GPL-linsensoitu videosoitinohjelma Unix-tyylisille
kyttjrjestelmille), joka muun muassa tarjoaa mahdollisuudet pakatun videon
ja nen purkamiseen (sek nyttmiseen) suurimmalla osalla nykyaikaista nen-
ja kuvanpakkausformaateista.
Tllaisia ovat mpeg-4 (DivX;-)), mpeg-2 (DVD, SVCD), mpeg-1 (VCD) muutamia
mainitaksemme. xinen purkukirjasto kytt monia matalan tason prosessoripohjaisia
optimisaatiomenetelmi tarjotakseen sulavan kuvantoistokokemuksen. Tm on tarpeen
mys minimoimaan tarvittavaa prosessoritehoa.

Olet tervetullut kyttmn %{name}:a omissa projekteissasi kunhan ne ovat GPL-
lisenssin kanssa yhteensopivia. listietoja GPL-lisenssist lytyy osoitteesta:
http://www.gnu.org/licenses/gpl.html

%prep
%setup -q -n xine-lib-1-beta12

%build
export CFLAGS="%{optflags}"

if [ ! -f configure ]; then
   NO_CONFIGURE=1 ./autogen.sh
fi

#
# currently we do not use %%configure as it seems to cause trouble with
# certain automake produced configure scripts - depending on automake version.
# Use BUILD_ARGS envvar to pass extra parameters to configure (like --enable-dha-mod/etc...)
#
./configure --build=%{_target_platform} --prefix=%{_prefix} \
	    --exec-prefix=%{_exec_prefix} --bindir=%{_bindir} \
	    --sbindir=%{_sbindir} --sysconfdir=%{_sysconfdir} \
	    --datadir=%{_datadir} --includedir=%{_includedir} \
	    --libdir=%{_libdir} --libexecdir=%{_libexecdir} \
	    --localstatedir=%{_localstatedir} \
	    --sharedstatedir=%{_sharedstatedir} --mandir=%{_mandir} \
	    --infodir=%{_infodir} $BUILD_ARGS
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=%{?buildroot:%{buildroot}} LIBRARY_PATH=%{?buildroot:%{buildroot}}%{_libdir} install

%clean
rm -rf $RPM_BUILD_ROOT

%post -n %{libname} -p /sbin/ldconfig
%postun -n %{libname} -p /sbin/ldconfig

%files -n %{libname}
%defattr(-,root,root)
%doc README TODO AUTHORS COPYING ChangeLog
%doc %{_datadir}/doc/xine/READ*
%doc %{_datadir}/doc/xine/*.dia
%doc %{_datadir}/doc/xine/faq/faq.*
%{_bindir}/xine-config
%{_libdir}/libxine*.so.*
%{_libdir}/pkgconfig/*
%{_libdir}/xine/plugins/%{dirversion}/xineplug_*
%{_libdir}/xine/plugins/%{dirversion}/post/*
%{_datadir}/xine/libxine1/fonts/*
%{_mandir}/man1/*
%{_datadir}/locale/*

%files -n %{libname}-devel
%defattr(-,root,root)
%doc doc/hackersguide/*.sgml doc/hackersguide/*.fig doc/hackersguide/README
%{_libdir}/libxine*.so
%{_libdir}/libxine*.la
%{_includedir}/xine.h
%{_includedir}/xine/*.h
%{_datadir}/aclocal/xine.m4
#%ifos linux
##/lib/modules/%(sh -c 'uname -r')/misc/dhahelper.o
#%endif
%ifos linux freebsd
%ifarch i386 i486 i586 i686 i786 i868 i968 k6 k7 athlon
%{_libdir}/xine/plugins/%{dirversion}/vidix/*_vid.*
%endif
%endif


%changelog
* Sat Mar 08 2003 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- added missing doc-files
* Wed Jan 15 2003 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- removed man3 manpages in devel-filelist
* Tue Dec 24 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Update for libxine 1.0beta1 added pkgconfig-directory
* Wed Dec 11 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Update for libxine 1.0beta0, fonts-directory has been changed
* Sat Dec 07 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- added translation for finnish by Tuukka Pasanen <illuusio@mailcity.com>
- some updates to german and english descriptions
- added post-directory to file-list
* Sat Nov 09 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Final changes for libxine 1.0alpha1
* Mon Nov 04 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- another change to make it run with next version
* Sat Nov 02 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Changes for next xine version
* Sun Oct 27 2002 Manfred Tremmel <Manfred.Tremmel@iiv.de>
- Update of the german descriptions.
* Thu Jun 06 2002 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- ability to pass args to configure. Fix vidix/dhahelper inclusion.
* Mon May 27 2002 Matthias Dahl <matthew2k@web.de>
- added passing of build parameter to configure
* Sun May 26 2002 Matthias Dahl <matthew2k@web.de>
- added german translations by Manfred Tremmel <Manfred.Tremmel@iiv.de>
- added fixes (missing -l cs) by Manfred Tremmel <Manfred.Tremmel@iiv.de>
* Sat May 18 2002 Matthias Dahl <matthew2k@web.de>
- added czech translations by valtri@atlas.cz
* Thu May 16 2002 Matthias Dahl <matthew2k@web.de>
- replaced %configure because it was causing trouble on certain configurations
* Sat May 11 2002 Matthias Dahl <matthew2k@web.de>
- reworked/revamped spec file, still needs some tuning (BuildPreReq, ...)
* Thu May 2 2002 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- sync with new logo stuff.
* Wed May 1 2002 Matthias Dahl <matthew2k@web.de>
- added cinepak, cyuv and msvc decode plugins
- commented out sdl related parts because this is currently broken in xine-lib
- added 'cs,pl_PL' translation catalogs
* Sun Mar 31 2002 Matthias Dahl <matthew2k@web.de>
- added mms input plugin, spucc decoder and missing xine_logo.zyuy2.
- commented out video fill decoder for now as it seems to be no longer built
* Wed Feb 6 2002 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- added 'de,fr,pt_BR' translation catalogs.
* Sat Dec 26 2001 Matthias Dahl <matthew2k@web.de>
- added sputext decode plugin and fonts.
* Sat Dec 8 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- ASF plugin is optional.
* Thu Dec 6 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add cda plugins.
* Wed Nov 14 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- fixed dxr3 header files inclusion, aalib deps: thanks to Andrew Meredith <andrew@anvil.org>.
* Mon Oct 29 2001 Matthias Dahl <matthew2k@web.de>
- added http input plugin
* Thu Oct 18 2001 Matthias Dahl <matthew2k@web.de>
- added asf demuxer plugin
* Sun Oct 14 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- move vorbis in separate package. Add DivX4 decoder plugin.
* Wed Oct 10 2001 Matthias Dahl <matthew2k@web.de>
- added vorbis files and missing man pages to filelist.
* Thu Sep 27 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add desktop stuff from patches by Miguel Freitas <miguel@cetuc.puc-rio.br>
- Fixed xine.m4 installation from Andrew Meredith <andrew@anvil.org>
* Fri Sep 21 2001 Matthias Dahl <matthew2k@web.de>
- added two missing files (xine-config man page and xine.m4)
* Sun Sep 16 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Merge patch from Jos Carlos Monteiro <jcm@netcabo.pt>:
  - Filelist and other minor updates,
  - Fixed some SuSE compatibility issues,
  - Added Portuguese summary.
* Sun Sep 16 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Add missing files.
* Sun Aug 19 2001 Matthias Dahl <matthew2k@web.de>
- The usual update to the filelist :)
- temporarily removed mpg123 decoder plugin from filelist cause it is not
  built with the recent CVS tree
* Thu Jul 26 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- Made oss, aa, xv, esd, w32dll, documentation as separate packages.
* Thu Jul 26 2001 Matthias Dahl <matthew2k@web.de>
- added seperate arts package and one missing demuxer plugin to filelist
* Wed Jul 18 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- list all plugins to avoid *strange* inclusion ;-).
* Sun Jun 10 2001 Matthias Dahl <matthew2k@web.de>
- updated filelist
- re-activated execution of /sbin/ldconfig as post install script
* Thu Mar 28 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- add korean summary, patch from Louis JANG <louis@ns.mizi.com>
* Thu Jan 11 2001 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- patch from Sung-Hyun Nam <namsh@lgic.co.kr> applied.
* Fri Oct 17 2000 Daniel Caujolle-Bert <f1rmb@users.sourceforge.net>
- first spec file.
